/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;

public class SubAwardLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String ORGANIZATION_NAME = "organizationName";
    private static final String REQUISITIONER_USER_NAME = "requisitionerUserName";
    static final String PERSON_ID = "personId";
    static final String ROLODEX_ID = "rolodexId";
    static final String UNIT_NUMBER = "unitNumber";
    static final String USER_ID = "userId";
    static final String PI_NAME = "principalInvestigatorName";
    static final String OSP_ADMIN_NAME = "ospAdministratorName";
    private VersionHistoryService versionHistoryService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        String awardNumber = fieldValues.get(AWARD_NUMBER);
        String requisitionerUserName = fieldValues.get(REQUISITIONER_USER_NAME);
        String subrecipientName = fieldValues.get(ORGANIZATION_NAME);
        fieldValues.remove(AWARD_NUMBER);
        fieldValues.remove(ORGANIZATION_NAME);
        fieldValues.remove(REQUISITIONER_USER_NAME);
        List unboundedResults = super.getSearchResultsUnbounded(fieldValues);
        List<Object> returnResults = new ArrayList();
        try {
            returnResults = this.filterForActiveSubAwards(unboundedResults, awardNumber, subrecipientName, requisitionerUserName, fieldValues.get("statusCode"));
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
        return returnResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<HtmlData> htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        htmlDataList.add((HtmlData)this.getOpenLink((SubAward)businessObject, false));
        htmlDataList.add((HtmlData)this.getMedusaLink((SubAward)businessObject, (Boolean)false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(SubAward subAward, Boolean viewOnly) {
        SubAwardDocument subAwardDocument = subAward.getSubAwardDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", viewOnly.toString());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("docId", subAwardDocument.getDocumentNumber());
        parameters.put("placeHolderAwardId", subAward.getSubAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMedusaLink(SubAward subAward, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("medusa");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "medusa");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", subAward.getSubAwardDocument().getDocumentNumber());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("placeHolderAwardId", subAward.getSubAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals("startDate") || field.getPropertyName().equals("endDate") || field.getPropertyName().equals("closeoutDate")) {
                    field.setDatePicker(true);
                }
                if (!field.getPropertyName().equals(REQUISITIONER_USER_NAME)) continue;
                field.setFieldConversions("principalName:requisitionerUserName,principalId:requisitionerId");
            }
        }
        return rows;
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    protected List<SubAward> filterForActiveSubAwards(Collection<SubAward> collectionByQuery, String awardNumber, String subrecipientName, String requisitionerUserName, String statusCode) throws WorkflowException {
        TreeSet<String> subAwardCodes = new TreeSet<String>();
        ArrayList<Integer> subAwardCodeList = new ArrayList<Integer>();
        ArrayList<String> subAwardCodeSortedList = new ArrayList<String>();
        for (SubAward subAward : collectionByQuery) {
            subAwardCodes.add(subAward.getSubAwardCode());
        }
        for (String string : subAwardCodes) {
            subAwardCodeList.add(Integer.parseInt(string));
        }
        Collections.sort(subAwardCodeList);
        for (Integer n : subAwardCodeList) {
            subAwardCodeSortedList.add(Integer.toString(n));
        }
        ArrayList<SubAward> activeSubAwards = new ArrayList<SubAward>();
        for (String versionName : subAwardCodeSortedList) {
            SubAward activeSubAward;
            VersionHistory versionHistory = this.versionHistoryService.findActiveVersion(SubAward.class, versionName);
            if (versionHistory == null || (activeSubAward = (SubAward)versionHistory.getSequenceOwner()) == null) continue;
            activeSubAwards.add(activeSubAward);
        }
        ArrayList<SubAward> arrayList = new ArrayList<SubAward>();
        for (SubAward subAward : activeSubAwards) {
            if (subrecipientName != null && !subrecipientName.equals("") && subAward.getOrganization().getOrganizationName() != null) {
                String subRecName = subrecipientName.replace("*", ".*").replace("?", ".");
                subRecName = subRecName.toLowerCase();
                if (!subAward.getOrganization().getOrganizationName().toLowerCase().matches(subRecName)) continue;
                arrayList.add(subAward);
                continue;
            }
            arrayList.add(subAward);
        }
        ArrayList<SubAward> filteredSubAwardList = new ArrayList<SubAward>();
        if (awardNumber != null && !awardNumber.equals("")) {
            Collection awards = this.getBusinessObjectService().findMatching(Award.class, ServiceHelper.getInstance().buildCriteriaMap(new String[]{AWARD_NUMBER}, new Object[]{awardNumber}));
            ArrayList<Award> linkedAwards = new ArrayList<Award>();
            for (Award award : awards) {
                linkedAwards.add(award);
            }
            ArrayList<SubAwardFundingSource> fundingSourceList = new ArrayList<SubAwardFundingSource>();
            for (Award linkedAward : linkedAwards) {
                Collection subAwardFundingSource = this.getBusinessObjectService().findMatching(SubAwardFundingSource.class, ServiceHelper.getInstance().buildCriteriaMap(new String[]{"awardId"}, new Object[]{linkedAward.getAwardId()}));
                for (SubAwardFundingSource subAwardFunding : subAwardFundingSource) {
                    fundingSourceList.add(subAwardFunding);
                }
            }
            for (SubAward subAward : arrayList) {
                for (SubAwardFundingSource subAwardFunding : fundingSourceList) {
                    if (!subAward.getSubAwardId().equals(subAwardFunding.getSubAwardId())) continue;
                    filteredSubAwardList.add(subAward);
                }
            }
        } else {
            for (SubAward subAward : arrayList) {
                filteredSubAwardList.add(subAward);
            }
        }
        ArrayList<SubAward> filteredSubAwardListSubAwards = new ArrayList<SubAward>();
        if (requisitionerUserName != null && !requisitionerUserName.equalsIgnoreCase("")) {
            for (SubAward subAward : filteredSubAwardList) {
                if (!subAward.getRequisitionerUserName().equalsIgnoreCase(requisitionerUserName) || !StringUtils.isEmpty((String)statusCode) && !StringUtils.equalsIgnoreCase((String)statusCode, (String)subAward.getStatusCode().toString())) continue;
                filteredSubAwardListSubAwards.add(subAward);
            }
        } else {
            for (SubAward subAward : filteredSubAwardList) {
                if (!StringUtils.isEmpty((String)statusCode) && !StringUtils.equalsIgnoreCase((String)statusCode, (String)subAward.getStatusCode().toString())) continue;
                filteredSubAwardListSubAwards.add(subAward);
            }
        }
        return filteredSubAwardListSubAwards;
    }

    @Override
    protected String getHtmlAction() {
        return "subAwardHome.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "SubAwardDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "SubAwardId";
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

