/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class SubAwardServiceImpl
implements SubAwardService {
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private VersionHistoryService versionHistoryService;
    private DocumentService documentService;
    private SequenceAccessorService sequenceAccessorService;
    private ParameterService parameterService;

    @Override
    public SubAwardDocument createNewSubAwardVersion(SubAwardDocument subAwardDocument) throws VersionException, WorkflowException {
        SubAward newVersion = this.getVersioningService().createNewVersion(subAwardDocument.getSubAward());
        SubAwardDocument newSubAwardDocument = (SubAwardDocument)this.getDocumentService().getNewDocument(SubAwardDocument.class);
        newSubAwardDocument.getDocumentHeader().setDocumentDescription(subAwardDocument.getDocumentHeader().getDocumentDescription());
        newSubAwardDocument.setSubAward(newVersion);
        newVersion.setSubAwardDocument(newSubAwardDocument);
        return newSubAwardDocument;
    }

    protected void incrementVersionNumberIfCanceledVersionsExist(SubAward subAward) {
        List versionHistory = (List)this.getBusinessObjectService().findMatching(VersionHistory.class, this.getHashMap(Long.toString(subAward.getSubAwardId())));
        subAward.setSequenceNumber(versionHistory.size() + 1);
    }

    protected Map<String, String> getHashMap(String subAwardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sequenceOwnerVersionNameValue", subAwardNumber);
        return map;
    }

    protected VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public void updateSubAwardSequenceStatus(SubAward subAward, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveSubAward(subAward.getSubAwardId());
        }
        subAward.setSubAwardSequenceStatus(status.toString());
        this.getBusinessObjectService().save((PersistableBusinessObject)subAward);
    }

    protected void archiveCurrentActiveSubAward(Long subAwardId) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("subAwardId", Long.toString(subAwardId));
        values.put("subAwardSequenceStatus", VersionStatus.ACTIVE.name());
        Collection subAwards = this.getBusinessObjectService().findMatching(SubAward.class, values);
        for (SubAward subAward : subAwards) {
            subAward.setSubAwardSequenceStatus(VersionStatus.ARCHIVED.name());
            this.getBusinessObjectService().save((PersistableBusinessObject)subAward);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public String getNextSubAwardCode() {
        Long nextAwardNumber = this.sequenceAccessorService.getNextAvailableSequenceNumber("SUBAWARD_CODE_S");
        return nextAwardNumber.toString();
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    @Override
    public SubAward getAmountInfo(SubAward subAward) {
        List<SubAwardAmountInfo> subAwardAmountInfoList = subAward.getSubAwardAmountInfoList();
        List<SubAwardAmountReleased> subAwardAmountReleasedList = subAward.getSubAwardAmountReleasedList();
        KualiDecimal totalObligatedAmount = new KualiDecimal(0.0);
        KualiDecimal totalAnticipatedAmount = new KualiDecimal(0.0);
        KualiDecimal totalAmountReleased = new KualiDecimal(0.0);
        if (subAwardAmountInfoList != null && subAwardAmountInfoList.size() > 0) {
            for (SubAwardAmountInfo subAwardAmountInfo : subAwardAmountInfoList) {
                if (subAwardAmountInfo.getObligatedChange() != null) {
                    subAward.setTotalObligatedAmount((KualiDecimal)totalObligatedAmount.add((AbstractKualiDecimal)subAwardAmountInfo.getObligatedChange()));
                    totalObligatedAmount = subAward.getTotalObligatedAmount();
                }
                if (subAwardAmountInfo.getAnticipatedChange() == null) continue;
                subAward.setTotalAnticipatedAmount((KualiDecimal)totalAnticipatedAmount.add((AbstractKualiDecimal)subAwardAmountInfo.getAnticipatedChange()));
                totalAnticipatedAmount = subAward.getTotalAnticipatedAmount();
            }
            for (SubAwardAmountReleased subAwardAmountReleased : subAwardAmountReleasedList) {
                if (subAwardAmountReleased.getAmountReleased() == null || StringUtils.equals((String)subAwardAmountReleased.getInvoiceStatus(), (String)DocumentStatus.DISAPPROVED.getCode()) || StringUtils.equals((String)subAwardAmountReleased.getInvoiceStatus(), (String)DocumentStatus.CANCELED.getCode()) || StringUtils.equals((String)subAwardAmountReleased.getInvoiceStatus(), (String)DocumentStatus.RECALLED.getCode())) continue;
                subAward.setTotalAmountReleased((KualiDecimal)totalAmountReleased.add((AbstractKualiDecimal)subAwardAmountReleased.getAmountReleased()));
                totalAmountReleased = subAward.getTotalAmountReleased();
            }
            SubAwardAmountInfo amountInfo = subAward.getSubAwardAmountInfoList().get(subAward.getSubAwardAmountInfoList().size() - 1);
            amountInfo.setAnticipatedAmount(totalAnticipatedAmount);
            amountInfo.setObligatedAmount(totalObligatedAmount);
        }
        subAward.setTotalObligatedAmount(totalObligatedAmount);
        subAward.setTotalAnticipatedAmount(totalAnticipatedAmount);
        subAward.setTotalAmountReleased(totalAmountReleased);
        subAward.setTotalAvailableAmount((KualiDecimal)totalObligatedAmount.subtract((AbstractKualiDecimal)totalAmountReleased));
        return subAward;
    }

    @Override
    public String getFollowupDateDefaultLength() {
        String namespaceCode = "KC-SUBAWARD";
        String componentCode = "Document";
        String parameterName = "Subaward Follow Up";
        String followupDateRange = this.getParameterService().getParameterValueAsString(namespaceCode, componentCode, parameterName);
        return followupDateRange;
    }

    @Override
    public Date getCalculatedFollowupDate(Date baseDate) {
        Date retDate = new Date(DateUtils.addDays((java.util.Date)baseDate, (int)this.getFollowupDateDefaultLengthInDays()).getTime());
        return retDate;
    }

    @Override
    public String getCalculatedFollowupDateForAjaxCall(String baseDate) {
        String empty = "";
        String[] elements = baseDate.split("/");
        if (elements.length == 3) {
            try {
                int month = Integer.parseInt(elements[0]);
                int day = Integer.parseInt(elements[1]);
                int year = Integer.parseInt(elements[2]);
                if (year < 100) {
                    year += 2000;
                }
                Date requestedDate = new Date(year, month - 1, day - 1);
                Date followUpDate = this.getCalculatedFollowupDate(requestedDate);
                return followUpDate.getMonth() + 1 + "/" + (followUpDate.getDate() + 1) + "/" + followUpDate.getYear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public int getFollowupDateDefaultLengthInDays() {
        String followupDateRange = this.getFollowupDateDefaultLength();
        String rangeUnit = followupDateRange.substring(followupDateRange.length() - 1, followupDateRange.length());
        int rangeAmount = Integer.parseInt(followupDateRange.substring(0, followupDateRange.length() - 1));
        int returnAmount = 0;
        if (StringUtils.equalsIgnoreCase((String)rangeUnit, (String)"D")) {
            returnAmount = rangeAmount;
        } else if (StringUtils.equalsIgnoreCase((String)rangeUnit, (String)"W")) {
            returnAmount = rangeAmount * 7;
        } else {
            throw new IllegalArgumentException("An invalid range unit was set in the 'Subaward Follow Up' parameter: " + rangeUnit);
        }
        return returnAmount;
    }

    @Override
    public SubAward getActiveSubAward(Long subAwardId) {
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("subAwardId", subAwardId);
        List subAwards = (List)this.getBusinessObjectService().findMatching(SubAward.class, values);
        SubAward subAward = (SubAward)subAwards.get(0);
        this.getAmountInfo(subAward);
        return subAward;
    }

    @Override
    public List<SubAward> getLinkedSubAwards(Award award) {
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("awardId", award.getAwardId());
        Collection subAwardFundingSources = this.businessObjectService.findMatching(SubAwardFundingSource.class, values);
        TreeSet<String> subAwardSet = new TreeSet<String>();
        for (SubAwardFundingSource subAwardFundingSource : subAwardFundingSources) {
            subAwardSet.add(subAwardFundingSource.getSubAward().getSubAwardCode());
        }
        ArrayList<SubAward> subAwards = new ArrayList<SubAward>();
        for (String subAwardCode : subAwardSet) {
            VersionHistory activeVersion = this.getVersionHistoryService().findActiveVersion(SubAward.class, subAwardCode);
            if (activeVersion == null) {
                VersionHistory pendingVersion = this.getVersionHistoryService().findPendingVersion(SubAward.class, subAwardCode);
                if (pendingVersion == null) continue;
                subAwards.add((SubAward)pendingVersion.getSequenceOwner());
                continue;
            }
            subAwards.add((SubAward)activeVersion.getSequenceOwner());
        }
        return subAwards;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

