/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KeywordsService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.notification.SubAwardNotificationContext;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardAction
extends KraTransactionalDocumentActionBase {
    private transient SubAwardService subAwardService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        if (subAwardForm.getSubAward() != null) {
            SubAward subAward = KraServiceLocator.getService(SubAwardService.class).getAmountInfo(subAwardForm.getSubAward());
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            new AuditActionHelper().auditConditionally((SubAwardForm)form);
        }
        return actionForward;
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        ActionForward forward = this.handleDocument(mapping, form, request, response, subAwardForm);
        SubAwardDocument subAwardDocument = (SubAwardDocument)subAwardForm.getDocument();
        subAwardForm.initializeFormOrDocumentBasedOnCommand();
        SubAward subAward = KraServiceLocator.getService(SubAwardService.class).getAmountInfo(subAwardDocument.getSubAward());
        subAwardForm.getSubAwardDocument().setSubAward(subAward);
        return forward;
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, SubAwardForm subAwardForm) throws Exception {
        ActionForward forward = null;
        String command = subAwardForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            this.loadDocumentInForm(request, subAwardForm);
        } else if ("subAwardActions".equals(command)) {
            this.loadDocumentInForm(request, subAwardForm);
            forward = this.subAwardActions(mapping, (ActionForm)subAwardForm, request, response);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        return forward;
    }

    protected void loadDocumentInForm(HttpServletRequest request, SubAwardForm subAwardForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        SubAwardDocument retrievedDocument = (SubAwardDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        subAwardForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    public String buildForwardStringForActionListCommand(String forwardPath, String docIdRequestParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(forwardPath);
        sb.append("?");
        sb.append("docId");
        sb.append("=");
        sb.append(docIdRequestParameter);
        return sb.toString();
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiForm) throws WorkflowException {
        super.loadDocument(kualiForm);
        SubAward subAward = ((SubAwardForm)kualiForm).getSubAwardDocument().getSubAward();
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        this.checkSubAwardCode(subAward);
        String userId = GlobalVariables.getUserSession().getPrincipalName();
        if (subAward.getSubAwardId() == null) {
            this.getVersionHistoryService().updateVersionHistory(subAward, VersionStatus.PENDING, userId);
        }
        if (new SubAwardDocumentRule().processAddSubAwardBusinessRules(subAward)) {
            ActionForward forward = super.save(mapping, form, request, response);
            this.getSubAwardService().updateSubAwardSequenceStatus(subAward, VersionStatus.PENDING);
            return forward;
        }
        return mapping.findForward("basic");
    }

    public ActionForward subAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("subAward");
    }

    public ActionForward fundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("fundingSource");
    }

    public ActionForward financial(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("financial");
    }

    public ActionForward amountReleased(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("amountReleased");
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("contacts");
    }

    public ActionForward closeouts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("closeout");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    public ActionForward subAwardActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("subAwardActions");
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KraServiceLocator.getService(VersionHistoryService.class);
    }

    protected KeywordsService getKeywordService() {
        return KraServiceLocator.getService(KeywordsService.class);
    }

    public SubAwardService getSubAwardService() {
        if (this.subAwardService == null) {
            this.subAwardService = KraServiceLocator.getService(SubAwardService.class);
        }
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }

    protected void checkSubAwardCode(SubAward subAward) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        for (SubAwardCustomData customData : subAward.getSubAwardCustomDataList()) {
            customData.setSubAward(subAward);
        }
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.setAuditActivated(false);
        AuditActionHelper.ValidationState status = new AuditActionHelper().isValidSubmission(subAwardForm, true);
        if (status == AuditActionHelper.ValidationState.OK || status == AuditActionHelper.ValidationState.WARNING) {
            super.route(mapping, form, request, response);
            return this.sendNotification(mapping, subAwardForm, "501", "Submit SubAward");
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        subAwardForm.setAuditActivated(true);
        return mapping.findForward("basic");
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.setAuditActivated(false);
        AuditActionHelper.ValidationState status = new AuditActionHelper().isValidSubmission(subAwardForm, true);
        if (status == AuditActionHelper.ValidationState.OK || status == AuditActionHelper.ValidationState.WARNING) {
            super.blanketApprove(mapping, form, request, response);
            return this.sendNotification(mapping, subAwardForm, "501", "Submit SubAward");
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        subAwardForm.setAuditActivated(true);
        return mapping.findForward("basic");
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        ActionForward forward = mapping.findForward("basic");
        AuditActionHelper.ValidationState status = new AuditActionHelper().isValidSubmission(subAwardForm, true);
        if (status == AuditActionHelper.ValidationState.OK || status == AuditActionHelper.ValidationState.WARNING) {
            forward = super.approve(mapping, form, request, response);
            return forward;
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        return forward;
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        if (subAwardForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, subAwardForm);
        }
        subAwardForm.getMedusaBean().setMedusaViewRadio("0");
        subAwardForm.getMedusaBean().setModuleName("subaward");
        subAwardForm.getMedusaBean().setModuleIdentifier(subAwardForm.getSubAwardDocument().getSubAward().getSubAwardId());
        subAwardForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("medusa");
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return KraServiceLocator.getService(KualiRuleService.class).applyRules(event);
    }

    public ActionForward sendNotification(ActionMapping mapping, SubAwardForm subAwardForm, String notificationType, String notificationString) {
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        SubAwardNotificationContext context = new SubAwardNotificationContext(subAward, notificationType, notificationString, "subAward");
        if (subAwardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            subAwardForm.getNotificationHelper().initializeDefaultValues(context);
            return mapping.findForward("notificationEditor");
        }
        this.getNotificationService().sendNotification(context);
        return mapping.findForward("basic");
    }

    protected KcNotificationService getNotificationService() {
        return KraServiceLocator.getService(KcNotificationService.class);
    }
}

