/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.subaward.web.struts.action.SubAwardAction;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardHomeAction
extends SubAwardAction {
    private static final String DOC_HANDLER_URL_PATTERN = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";
    private static final String SUBAWARD_VERSION_EDITPENDING_PROMPT_KEY = "message.subaward.version.editpending.prompt";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        return actionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        ActionForward forward = super.save(mapping, form, request, response);
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        SubAwardForm subAwardMultiLookupForm = (SubAwardForm)form;
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        subAwardMultiLookupForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        subAwardMultiLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        SubAward subAward = subAwardMultiLookupForm.getSubAwardDocument().getSubAward();
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAward subaward = subAwardDocument.getSubAward();
        ActionForward forward = null;
        VersionHistory foundPending = this.findPendingVersion(subaward);
        forward = foundPending != null ? ((question = request.getParameter("buttonClicked")) == null ? this.showPromptForEditingPendingVersion(mapping, form, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, subAwardForm, foundPending)) : this.createAndSaveNewSubAwardVersion(response, subAwardForm, subAwardDocument, subaward);
        return forward;
    }

    private VersionHistory findPendingVersion(SubAward subaward) {
        List<VersionHistory> histories = this.getVersionHistoryService().loadVersionHistory(SubAward.class, subaward.getSubAwardCode());
        VersionHistory foundPending = null;
        for (VersionHistory history : histories) {
            if (history.getStatus() != VersionStatus.PENDING || subaward.getSequenceNumber() >= history.getSequenceOwnerSequenceNumber()) continue;
            foundPending = history;
            break;
        }
        return foundPending;
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(SUBAWARD_VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, SubAwardForm subAwardForm, VersionHistory foundPending) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("subAward");
        } else {
            this.initializeFormWithSubAward(subAwardForm, (SubAward)foundPending.getSequenceOwner());
            response.sendRedirect(this.makeDocumentOpenUrl(subAwardForm.getSubAwardDocument()));
            forward = null;
        }
        return forward;
    }

    private void initializeFormWithSubAward(SubAwardForm subAwardForm, SubAward subAward) throws WorkflowException {
        this.reinitializeSubAwardForm(subAwardForm, this.findDocumentForSubAward(subAward));
    }

    private SubAwardDocument findDocumentForSubAward(SubAward subAward) throws WorkflowException {
        SubAwardDocument document = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(subAward.getSubAwardDocument().getDocumentNumber());
        document.setSubAward(subAward);
        return document;
    }

    private ActionForward createAndSaveNewSubAwardVersion(HttpServletResponse response, SubAwardForm subAwardForm, SubAwardDocument subAwardDocument, SubAward subAward) throws Exception {
        subAwardForm.getSubAwardDocument().getSubAward().setNewVersion(true);
        SubAwardDocument newSubAwardDocument = this.getSubAwardService().createNewSubAwardVersion(subAwardForm.getSubAwardDocument());
        this.getDocumentService().saveDocument((Document)newSubAwardDocument);
        this.getSubAwardService().updateSubAwardSequenceStatus(newSubAwardDocument.getSubAward(), VersionStatus.PENDING);
        this.getVersionHistoryService().updateVersionHistory(newSubAwardDocument.getSubAward(), VersionStatus.PENDING, GlobalVariables.getUserSession().getPrincipalName());
        this.reinitializeSubAwardForm(subAwardForm, newSubAwardDocument);
        return new ActionForward(this.makeDocumentOpenUrl(newSubAwardDocument), true);
    }

    private String makeDocumentOpenUrl(SubAwardDocument newSubAwardDocument) {
        String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
        return String.format(DOC_HANDLER_URL_PATTERN, workflowUrl, newSubAwardDocument.getDocumentNumber());
    }

    private void reinitializeSubAwardForm(SubAwardForm subAwardForm, SubAwardDocument document) throws WorkflowException {
        subAwardForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        subAwardForm.setDocument((Document)document);
        document.setDocumentSaveAfterSubAwardLookupEditOrVersion(true);
        subAwardForm.initialize();
    }

    public ActionForward addFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        SubAwardFundingSource fundingSources = subAwardForm.getNewSubAwardFundingSource();
        if (new SubAwardDocumentRule().processAddSubAwardFundingSourceBusinessRules(fundingSources, subAward)) {
            this.addFundingSourceToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), fundingSources);
            subAwardForm.setNewSubAwardFundingSource(new SubAwardFundingSource());
        }
        return mapping.findForward("subAward");
    }

    boolean addFundingSourceToSubAward(SubAward subAward, SubAwardFundingSource fundingSources) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        fundingSources.setSubAward(subAward);
        return subAward.getSubAwardFundingSourceList().add(fundingSources);
    }

    public ActionForward deleteFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        SubAwardFundingSource subAwardFundingSource = subAwardDocument.getSubAward().getSubAwardFundingSourceList().get(selectedLineNumber);
        subAwardDocument.getSubAward().getSubAwardFundingSourceList().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }

    public ActionForward addContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAward subAward;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardContact subAwardContact = subAwardForm.getNewSubAwardContact();
        if (new SubAwardDocumentRule().processAddSubAwardContactBusinessRules(subAwardContact, subAward = subAwardForm.getSubAwardDocument().getSubAward())) {
            this.addContactsToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), subAwardContact);
            subAwardForm.setNewSubAwardContact(new SubAwardContact());
        }
        return mapping.findForward("subAward");
    }

    boolean addContactsToSubAward(SubAward subAward, SubAwardContact subAwardContact) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        subAwardContact.setSubAward(subAward);
        return subAward.getSubAwardContactsList().add(subAwardContact);
    }

    public ActionForward deleteContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        SubAwardContact subAwardContact = subAwardDocument.getSubAward().getSubAwardContactsList().get(selectedLineNumber);
        subAwardDocument.getSubAward().getSubAwardContactsList().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }

    public ActionForward addCloseouts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardCloseout subAwardCloseout = subAwardForm.getNewSubAwardCloseout();
        if (new SubAwardDocumentRule().processAddSubAwardCloseoutBusinessRules(subAwardCloseout)) {
            if (subAwardCloseout.getDateFollowup() == null) {
                subAwardCloseout.setDateFollowup(this.getSubAwardService().getCalculatedFollowupDate(subAwardCloseout.getDateRequested()));
            }
            this.addCloseoutToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), subAwardCloseout);
            subAwardForm.setNewSubAwardCloseout(new SubAwardCloseout());
        }
        return mapping.findForward("subAward");
    }

    boolean addCloseoutToSubAward(SubAward subAward, SubAwardCloseout subAwardCloseout) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        subAwardCloseout.setSubAward(subAward);
        return subAward.getSubAwardCloseoutList().add(subAwardCloseout);
    }

    public ActionForward deleteCloseout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        SubAwardCloseout subAwardCloseout = subAwardDocument.getSubAward().getSubAwardCloseoutList().get(selectedLineNumber);
        subAwardDocument.getSubAward().getSubAwardCloseoutList().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }
}

