/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardHierarchyUIService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)KNSGlobalVariables.getKualiForm();
        TimeAndMoneyDocument document = timeAndMoneyForm == null ? this.updateDocumentFromSession() : timeAndMoneyForm.getTimeAndMoneyDocument();
        document.setAwardHierarchyItems(((TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY")).getAwardHierarchyItems());
        if (document.getAwardHierarchyItems() != null && document.getAwardHierarchyItems().size() != 0) {
            Object[] keyset = document.getAwardHierarchyItems().keySet().toArray();
            Arrays.sort(keyset);
            for (Object awardNumber : keyset) {
                keyValues.add((KeyValue)new ConcreteKeyValue((String)awardNumber, document.getAwardHierarchyItems().get(awardNumber).getAwardNumber()));
            }
        }
        return keyValues;
    }

    private TimeAndMoneyDocument updateDocumentFromSession() {
        if (GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY") == null) {
            throw new RuntimeException("Can't Retrieve Time And Money Document from Session");
        }
        TimeAndMoneyDocument document = (TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
        document.setAwardHierarchyItems(document.getAwardHierarchyItems());
        document.setAwardHierarchyNodes(document.getAwardHierarchyNodes());
        document.setRootAwardNumber(this.getRootAwardFromHierarchyNodes(document));
        return document;
    }

    private String getRootAwardFromHierarchyNodes(TimeAndMoneyDocument document) {
        String rootAwardNumber = null;
        for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : document.getAwardHierarchyNodes().entrySet()) {
            if (awardHierarchyNode == null) continue;
            rootAwardNumber = awardHierarchyNode.getValue().getRootAwardNumber();
        }
        return rootAwardNumber;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return KraServiceLocator.getService(AwardHierarchyService.class);
    }

    public AwardHierarchyUIService getAwardHierarchyUIService() {
        return KraServiceLocator.getService(AwardHierarchyUIService.class);
    }
}

