/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistributionBean;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardHierarchyUIService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.transactions.TransactionBean;
import org.kuali.kra.web.struts.form.KraTransactionalDocumentFormBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.util.AutoPopulatingList;

public class TimeAndMoneyForm
extends KraTransactionalDocumentFormBase {
    public static final String COLUMN = ":";
    private static final int NUMBER_30 = 30;
    public static final String UPDATE_TIMESTAMP_DD_NAME = "DataDictionary.Award.attributes.updateTimestamp";
    public static final String SPONSOR_DD_NAME = "DataDictionary.Sponsor.attributes.sponsorName";
    private static final long serialVersionUID = 2737159069734793860L;
    private TransactionBean transactionBean;
    private AwardDirectFandADistributionBean awardDirectFandADistributionBean;
    private String goToAwardNumber;
    private List<String> order;
    private List<Integer> columnSpan;
    private List<String> obligationStartDates;
    private List<String> obligationExpirationDates;
    private List<String> finalExpirationDates;
    private List<AwardHierarchyNode> awardHierarchyNodeItems;
    private String awardHierarchy;
    private String awardNumber;
    private String addRA;
    private String deletedRas;
    private String controlForAwardHierarchyView;
    private String currentOrPendingView;
    private String directIndirectViewEnabled;
    private Map<String, String> previousNodeMap;
    private Map<String, String> nextNodeMap;
    private Award awardForSummaryPanelDisplay;
    private transient ParameterService parameterService;
    private String currentAwardNumber;
    private String currentSeqNumber;
    private Map<String, String> awardHierarchyToggle;
    private String awardHierarchyScrollPosition;
    public static final String PENDING = "1";
    public static final String CURRENT = "0";
    private List<String> fieldsInError;

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getCurrentSeqNumber() {
        return this.currentSeqNumber;
    }

    public void setCurrentSeqNumber(String currentSeqNumber) {
        this.currentSeqNumber = currentSeqNumber;
    }

    public TimeAndMoneyForm() {
        this.initialize();
    }

    public void initialize() {
        this.transactionBean = new TransactionBean(this);
        this.awardDirectFandADistributionBean = new AwardDirectFandADistributionBean(this);
        this.order = new ArrayList<String>();
        this.columnSpan = new ArrayList<Integer>();
        this.obligationStartDates = new AutoPopulatingList(String.class);
        this.obligationExpirationDates = new AutoPopulatingList(String.class);
        this.finalExpirationDates = new AutoPopulatingList(String.class);
        this.awardHierarchyNodeItems = new AutoPopulatingList(AwardHierarchyNode.class);
        this.setControlForAwardHierarchyView("2");
        this.setToCurrentView();
        this.setDirectIndirectViewEnabled(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"));
        this.previousNodeMap = new HashMap<String, String>();
        this.nextNodeMap = new HashMap<String, String>();
        this.awardHierarchyToggle = new TreeMap<String, String>();
        this.fieldsInError = new ArrayList<String>();
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "TimeAndMoneyDocument";
    }

    public void initializeFormOrDocumentBasedOnCommand() {
        if ("initiate".equals(this.getCommand())) {
            this.getTimeAndMoneyDocument().initialize();
        } else {
            this.initialize();
        }
    }

    @Override
    public void populate(HttpServletRequest request) {
        this.registerEditableProperty("controlForAwardHierarchyView");
        this.registerEditableProperty("currentOrPendingView");
        this.registerEditableProperty("directIndirectViewEnabled");
        super.populate(request);
    }

    public boolean isPropertyEditable(String propertyName) {
        if (propertyName.startsWith("awardHierarchyNodeItems[")) {
            return true;
        }
        return super.isPropertyEditable(propertyName);
    }

    public TimeAndMoneyDocument getTimeAndMoneyDocument() {
        return (TimeAndMoneyDocument)super.getDocument();
    }

    @Override
    protected String getLockRegion() {
        return "TIME_AND_MONEY";
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
    }

    protected DataDictionaryService getDataDictionaryService() {
        return (DataDictionaryService)KraServiceLocator.getService("dataDictionaryService");
    }

    public BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    public ActivePendingTransactionsService getActivePendingTransactionsService() {
        return KraServiceLocator.getService(ActivePendingTransactionsService.class);
    }

    public AwardVersionService getAwardVersionService() {
        return KraServiceLocator.getService(AwardVersionService.class);
    }

    public TransactionBean getTransactionBean() {
        return this.transactionBean;
    }

    public void setTransactionBean(TransactionBean transactionBean) {
        this.transactionBean = transactionBean;
    }

    public String getGoToAwardNumber() {
        return this.goToAwardNumber;
    }

    public void setGoToAwardNumber(String goToAwardNumber) {
        this.goToAwardNumber = goToAwardNumber;
    }

    public List<String> getOrder() {
        return this.order;
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    public List<Integer> getColumnSpan() {
        return this.columnSpan;
    }

    public void setColumnSpan(List<Integer> columnSpan) {
        this.columnSpan = columnSpan;
    }

    private AwardHierarchyUIService getAwardHierarchyUIService() {
        return KraServiceLocator.getService(AwardHierarchyUIService.class);
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public String getAddRA() {
        return this.addRA;
    }

    public void setAddRA(String addRA) {
        this.addRA = addRA;
    }

    public String getDeletedRas() {
        return this.deletedRas;
    }

    public void setDeletedRas(String deletedRas) {
        this.deletedRas = deletedRas;
    }

    public AwardDirectFandADistributionBean getAwardDirectFandADistributionBean() {
        return this.awardDirectFandADistributionBean;
    }

    public void setAwardDirectFandADistributionBean(AwardDirectFandADistributionBean awardDirectFandADistributionBean) {
        this.awardDirectFandADistributionBean = awardDirectFandADistributionBean;
    }

    public String getControlForAwardHierarchyView() {
        return this.controlForAwardHierarchyView;
    }

    public void setControlForAwardHierarchyView(String controlForAwardHierarchyView) {
        this.controlForAwardHierarchyView = controlForAwardHierarchyView;
    }

    public boolean isCancelOrFinalStatus() {
        return this.getDocument().getDocumentHeader().getWorkflowDocument().isCanceled() || this.getDocument().getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public boolean isInSingleNodeHierarchy() {
        boolean returnValue = false;
        if (this.getOrder().size() == 1) {
            returnValue = true;
            this.setControlForAwardHierarchyView("2");
        }
        return returnValue;
    }

    public boolean isInMultipleNodeHierarchy() {
        boolean returnValue = false;
        if (this.getOrder().size() > 1) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isRootNode() {
        boolean returnVal = false;
        String awardNumber = this.getAwardForSummaryPanelDisplay().getAwardNumber();
        if (this.getPreviousNodeMap().get(awardNumber).equals("000000-00000")) {
            returnVal = true;
        }
        return returnVal;
    }

    public boolean isLastNode() {
        boolean returnVal = false;
        String awardNumber = this.getAwardForSummaryPanelDisplay().getAwardNumber();
        if (this.getNextNodeMap().get(awardNumber).equals("lastNodeNextValue")) {
            returnVal = true;
        }
        return returnVal;
    }

    public Award getAwardForSummaryPanelDisplay() {
        return this.awardForSummaryPanelDisplay;
    }

    public void setAwardForSummaryPanelDisplay(Award awardForSummaryPanelDisplay) {
        this.awardForSummaryPanelDisplay = awardForSummaryPanelDisplay;
    }

    public List<String> getObligationStartDates() {
        return this.obligationStartDates;
    }

    public void setObligationStartDates(List<String> obligationStartDates) {
        this.obligationStartDates = obligationStartDates;
    }

    public List<String> getObligationExpirationDates() {
        return this.obligationExpirationDates;
    }

    public void setObligationExpirationDates(List<String> obligationExpirationDates) {
        this.obligationExpirationDates = obligationExpirationDates;
    }

    public List<String> getFinalExpirationDates() {
        return this.finalExpirationDates;
    }

    public void setFinalExpirationDates(List<String> finalExpirationDates) {
        this.finalExpirationDates = finalExpirationDates;
    }

    public List<AwardHierarchyNode> getAwardHierarchyNodeItems() {
        return this.awardHierarchyNodeItems;
    }

    public void setAwardHierarchyNodeItems(List<AwardHierarchyNode> awardHierarchyNodeItems) {
        this.awardHierarchyNodeItems = awardHierarchyNodeItems;
    }

    public Map<String, String> getPreviousNodeMap() {
        return this.previousNodeMap;
    }

    public void setPreviousNodeMap(Map<String, String> previousNodeMap) {
        this.previousNodeMap = previousNodeMap;
    }

    public Map<String, String> getNextNodeMap() {
        return this.nextNodeMap;
    }

    public void setNextNodeMap(Map<String, String> nextNodeMap) {
        this.nextNodeMap = nextNodeMap;
    }

    public String getAwardHierarchy() throws ParseException {
        this.awardHierarchy = "";
        if (StringUtils.isBlank((String)this.awardNumber)) {
            this.awardNumber = this.getTimeAndMoneyDocument().getRootAwardNumber();
        }
        if (this.awardNumber != null && StringUtils.isNotBlank((String)this.addRA) && this.addRA.equals("E")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getSubAwardHierarchiesForTreeView(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        } else if (this.awardNumber != null && StringUtils.isNotBlank((String)this.addRA) && this.addRA.equals("N")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getRootAwardNode(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        }
        return this.awardHierarchy;
    }

    public void setAwardHierarchy(String awardHierarchy) {
        this.awardHierarchy = awardHierarchy;
    }

    public String getCurrentOrPendingView() {
        return this.currentOrPendingView;
    }

    public void setToCurrentView() {
        this.currentOrPendingView = CURRENT;
    }

    public void setToPendingView() {
        this.currentOrPendingView = PENDING;
    }

    public boolean getDisableCurrentValues() {
        return StringUtils.equals((String)CURRENT, (String)this.getCurrentOrPendingView()) && !this.getTimeAndMoneyDocument().getPendingTransactions().isEmpty();
    }

    public void setCurrentOrPendingView(String currentOrPendingView) {
        this.currentOrPendingView = currentOrPendingView;
    }

    public List<ExtraButton> getExtraTopButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String generatePeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "tinybutton1-returntoaward.gif";
        this.addExtraButton("methodToCall.returnToAward", generatePeriodImage, "Return to Award");
        return this.extraButtons;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        TimeAndMoneyDocument timeAndMoneyDocument = this.getTimeAndMoneyDocument();
        if (timeAndMoneyDocument.getAward() == null) {
            Award award = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyDocument.getRootAwardNumber());
            timeAndMoneyDocument.setAward(award);
        }
        AwardDocument awardDocument = timeAndMoneyDocument.getAward().getAwardDocument();
        this.getDocInfo().clear();
        this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.principalInvestigator", awardDocument.getAward().getPrincipalInvestigatorName()));
        String docIdAndStatus = COLUMN;
        if (workflowDocument != null) {
            docIdAndStatus = timeAndMoneyDocument.getDocumentNumber() + COLUMN + workflowDocument.getStatus().getLabel();
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.docIdStatus", docIdAndStatus));
        String unitName = awardDocument.getAward().getUnitName();
        if (StringUtils.isNotBlank((String)unitName) && unitName.length() > 30) {
            unitName = unitName.substring(0, 30);
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.AwardPersonUnit.attributes.leadUnit", unitName));
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.awardIdAccount", this.getAwardIdAccount(awardDocument)));
        this.setupSponsor(awardDocument);
        this.setupLastUpdate(awardDocument);
    }

    private String getAwardIdAccount(AwardDocument awardDocument) {
        String awardNum = awardDocument.getAward().getAwardNumber();
        String account = awardDocument.getAward().getAccountNumber() != null ? awardDocument.getAward().getAccountNumber() : "";
        return awardNum + COLUMN + account;
    }

    private void setupLastUpdate(AwardDocument awardDocument) {
        String createDateStr = null;
        String updateUser = null;
        if (awardDocument.getUpdateTimestamp() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)awardDocument.getUpdateTimestamp(), "MM/dd/yy");
            updateUser = awardDocument.getUpdateUser().length() > 30 ? awardDocument.getUpdateUser().substring(0, 30) : awardDocument.getUpdateUser();
            this.getDocInfo().add(new HeaderField(UPDATE_TIMESTAMP_DD_NAME, createDateStr + " by " + updateUser));
        } else {
            this.getDocInfo().add(new HeaderField(UPDATE_TIMESTAMP_DD_NAME, ""));
        }
    }

    private void setupSponsor(AwardDocument awardDocument) {
        if (awardDocument.getAward().getSponsor() == null) {
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, ""));
        } else {
            String sponsorName = awardDocument.getAward().getSponsorName();
            if (StringUtils.isNotBlank((String)sponsorName) && sponsorName.length() > 30) {
                sponsorName = sponsorName.substring(0, 30);
            }
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, sponsorName));
        }
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public String getDirectIndirectViewEnabled() {
        return this.directIndirectViewEnabled;
    }

    public void setDirectIndirectViewEnabled(String directIndirectViewEnabled) {
        this.directIndirectViewEnabled = directIndirectViewEnabled;
    }

    protected KraWorkflowService getKraWorkflowService() {
        return KraServiceLocator.getService(KraWorkflowService.class);
    }

    public boolean getDisplayEditButton() throws Exception {
        boolean displayEditButton = Boolean.FALSE;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        String rootAwardNumber = this.getTimeAndMoneyDocument().getRootAwardNumber();
        fieldValues.put("rootAwardNumber", rootAwardNumber);
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        List timeAndMoneyDocuments = (List)businessObjectService.findMatching(TimeAndMoneyDocument.class, fieldValues);
        Collections.sort(timeAndMoneyDocuments);
        TimeAndMoneyDocument lastFinalDoc = this.getLastFinalTandMDocument(timeAndMoneyDocuments);
        if (lastFinalDoc != null) {
            displayEditButton = lastFinalDoc.getDocumentHeader().getWorkflowDocument().isFinal() && lastFinalDoc.getDocumentNumber().equals(this.getTimeAndMoneyDocument().getDocumentNumber());
        }
        return displayEditButton;
    }

    protected TimeAndMoneyDocument getLastFinalTandMDocument(List<TimeAndMoneyDocument> timeAndMoneyDocuments) throws WorkflowException {
        TimeAndMoneyDocument returnVal = null;
        DocumentService documentService = KraServiceLocator.getService(DocumentService.class);
        while (timeAndMoneyDocuments.size() > 0) {
            TimeAndMoneyDocument docWithWorkFlowData = (TimeAndMoneyDocument)documentService.getByDocumentHeaderId(timeAndMoneyDocuments.get(timeAndMoneyDocuments.size() - 1).getDocumentNumber());
            if (docWithWorkFlowData.getDocumentHeader().getWorkflowDocument().isCanceled()) {
                timeAndMoneyDocuments.remove(timeAndMoneyDocuments.size() - 1);
                continue;
            }
            returnVal = docWithWorkFlowData;
            break;
        }
        return returnVal;
    }

    public List<ExtraButton> getExtraButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String reloadImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_reload.gif";
        this.addExtraButton("methodToCall.reload", reloadImage, null);
        return this.extraButtons;
    }

    @Override
    protected void addExtraButton(String property, String source, String altText) {
        this.addExtraButton(property, source, altText, null);
    }

    protected void addExtraButton(String property, String source, String altText, String extraButtonOnclick) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        if (extraButtonOnclick != null) {
            newButton.setExtraButtonOnclick(extraButtonOnclick);
        }
        this.extraButtons.add(newButton);
    }

    public int getIndexOfAwardAmountInfoForDisplay() throws WorkflowException {
        return this.awardForSummaryPanelDisplay.getIndexOfAwardAmountInfoForDisplayFromTimeAndMoneyDocNumber(this.getTimeAndMoneyDocument().getDocumentNumber());
    }

    public Map<String, String> getAwardHierarchyToggle() {
        return this.awardHierarchyToggle;
    }

    public void setAwardHierarchyToggle(Map<String, String> awardHierarchyToggle) {
        this.awardHierarchyToggle = awardHierarchyToggle;
    }

    public String getAwardHierarchyScrollPosition() {
        return this.awardHierarchyScrollPosition;
    }

    public void setAwardHierarchyScrollPosition(String awardHierarchyScrollPosition) {
        this.awardHierarchyScrollPosition = awardHierarchyScrollPosition;
    }

    public List<String> getFieldsInError() {
        return this.fieldsInError;
    }

    public void setFieldsInError(List<String> fieldsInError) {
        this.fieldsInError = fieldsInError;
    }

    public boolean getIsFieldInErrorList(String fieldName) {
        boolean returnValue = this.getFieldsInError().contains(fieldName);
        System.err.println("getIsFieldInErrorList  fieldName: " + fieldName + "   returningL " + returnValue);
        return returnValue;
    }

    public String getFieldsInErrorList() {
        StringBuffer sb = new StringBuffer("foo");
        for (String s : this.getFieldsInError()) {
            sb.append(",").append(s);
        }
        return sb.toString();
    }
}

