/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.AwardVersionHistory;
import org.kuali.kra.timeandmoney.document.PendingTransactionComparator;
import org.kuali.kra.timeandmoney.history.TimeAndMoneyActionSummary;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.ObjectUtils;

public class TimeAndMoneyDocument
extends ResearchDocumentBase
implements Copyable,
SessionDocument,
Permissionable,
Comparable {
    private static final long serialVersionUID = -2554022334215932544L;
    public static final String DOCUMENT_TYPE_CODE = "TAMD";
    private String rootAwardNumber;
    private String awardNumber;
    private Map<String, AwardHierarchyNode> awardHierarchyNodes;
    private Map<String, AwardHierarchy> awardHierarchyItems;
    private List<PendingTransaction> pendingTransactions;
    private List<AwardAmountTransaction> awardAmountTransactions;
    private Map<Object, Object> timeAndMoneyHistory;
    private List<TimeAndMoneyActionSummary> timeAndMoneyActionSummaryItems;
    private Award award;
    private AwardAmountTransaction newAwardAmountTransaction;
    private List<AwardDirectFandADistribution> awardDirectFandADistributions;
    private List<AwardVersionHistory> awardVersionHistoryList;
    private List<String> order;

    public TimeAndMoneyDocument() {
        this.init();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public boolean isInitialSave() {
        return this.getObjectId() == null;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.pendingTransactions);
        return managedLists;
    }

    protected void init() {
        this.awardHierarchyNodes = new TreeMap<String, AwardHierarchyNode>();
        this.awardHierarchyItems = new HashMap<String, AwardHierarchy>();
        this.pendingTransactions = new ArrayList<PendingTransaction>();
        this.awardAmountTransactions = new ArrayList<AwardAmountTransaction>();
        this.timeAndMoneyHistory = new LinkedHashMap<Object, Object>();
        this.timeAndMoneyActionSummaryItems = new ArrayList<TimeAndMoneyActionSummary>();
        this.awardDirectFandADistributions = new ArrayList<AwardDirectFandADistribution>();
        this.newAwardAmountTransaction = new AwardAmountTransaction();
        this.awardVersionHistoryList = new ArrayList<AwardVersionHistory>();
        this.order = new ArrayList<String>();
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (StringUtils.equals((String)"P", (String)statusChangeEvent.getNewRouteStatus())) {
            this.setAwardHierarchyItems(this.getAwardHierarchyService().getAwardHierarchy(this.rootAwardNumber, this.getOrder()));
            this.setAwardNumber(this.rootAwardNumber);
            Award tmpAward = this.getCurrentAward(this);
            this.setAward(tmpAward);
            if (tmpAward != null) {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(this.getAwardHierarchyItems(), this.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), this);
            } else {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(this.getAwardHierarchyItems(), this.getAwardHierarchyNodes(), null, null, this);
            }
            this.getActivePendingTransactionsService().approveTransactions(this, this.awardAmountTransactions.get(0));
        }
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return KraServiceLocator.getService(AwardHierarchyService.class);
    }

    private Award getCurrentAward(TimeAndMoneyDocument timeAndMoneyDocument) {
        Award tmpAward = timeAndMoneyDocument.getAward();
        if (tmpAward == null) {
            tmpAward = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyDocument.getAwardNumber());
        }
        return tmpAward;
    }

    public AwardVersionService getAwardVersionService() {
        return KraServiceLocator.getService(AwardVersionService.class);
    }

    protected ActivePendingTransactionsService getActivePendingTransactionsService() {
        return KraServiceLocator.getService(ActivePendingTransactionsService.class);
    }

    @Override
    public String getDocumentKey() {
        return "award";
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getRootAwardNumber();
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roles = new ArrayList<String>();
        return roles;
    }

    public boolean getDocumentRouteStatus() {
        return this.getDocumentHeader().getWorkflowDocument().isEnroute() || this.getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public boolean isNew() {
        return this.documentNumber == null;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public Map<String, AwardHierarchyNode> getAwardHierarchyNodes() {
        return this.awardHierarchyNodes;
    }

    public void setAwardHierarchyNodes(Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        this.awardHierarchyNodes = awardHierarchyNodes;
    }

    public List<PendingTransaction> getPendingTransactions() {
        Collections.sort(this.pendingTransactions, new PendingTransactionComparator());
        return this.pendingTransactions;
    }

    public void setPendingTransactions(List<PendingTransaction> pendingTransactions) {
        this.pendingTransactions = pendingTransactions;
    }

    public void add(PendingTransaction newPendingTransaction) {
        this.getPendingTransactions().add(newPendingTransaction);
    }

    public Map<String, AwardHierarchy> getAwardHierarchyItems() {
        return this.awardHierarchyItems;
    }

    public void setAwardHierarchyItems(Map<String, AwardHierarchy> awardHierarchyItems) {
        this.awardHierarchyItems = awardHierarchyItems;
    }

    public List<AwardAmountTransaction> getAwardAmountTransactions() {
        return this.awardAmountTransactions;
    }

    public void setAwardAmountTransactions(List<AwardAmountTransaction> awardAmountTransactions) {
        this.awardAmountTransactions = awardAmountTransactions;
    }

    public Map<Object, Object> getTimeAndMoneyHistory() {
        return this.timeAndMoneyHistory;
    }

    public void setTimeAndMoneyHistory(Map<Object, Object> timeAndMoneyHistory) {
        this.timeAndMoneyHistory = timeAndMoneyHistory;
    }

    public List<TimeAndMoneyActionSummary> getTimeAndMoneyActionSummaryItems() {
        return this.timeAndMoneyActionSummaryItems;
    }

    public void setTimeAndMoneyActionSummaryItems(List<TimeAndMoneyActionSummary> timeAndMoneyActionSummaryItems) {
        this.timeAndMoneyActionSummaryItems = timeAndMoneyActionSummaryItems;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public AwardAmountTransaction getNewAwardAmountTransaction() {
        return this.newAwardAmountTransaction;
    }

    public void setNewAwardAmountTransaction(AwardAmountTransaction newAwardAmountTransaction) {
        this.newAwardAmountTransaction = newAwardAmountTransaction;
    }

    public String getRootAwardNumber() {
        return this.rootAwardNumber;
    }

    public void setRootAwardNumber(String rootAwardNumber) {
        this.rootAwardNumber = rootAwardNumber;
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public String getLeadUnitNumber() {
        if (this.getAward() != null) {
            return this.getAward().getLeadUnitNumber();
        }
        return null;
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-AWARD";
    }

    public List<AwardVersionHistory> getAwardVersionHistoryList() {
        return this.awardVersionHistoryList;
    }

    public void setAwardVersionHistoryList(List<AwardVersionHistory> awardVersionHistoryList) {
        this.awardVersionHistoryList = awardVersionHistoryList;
    }

    public List<String> getOrder() {
        return this.order;
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        TimeAndMoneyDocument comparator = (TimeAndMoneyDocument)o;
        String myKey = StringUtils.leftPad((String)this.getDocumentNumber(), (int)40);
        String otherKey = StringUtils.leftPad((String)comparator.getDocumentNumber(), (int)40);
        return myKey.compareTo(otherKey);
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }
}

