/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.rules;

import java.sql.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.rule.event.TimeAndMoneyAwardAmountTransactionSaveEvent;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardAmountTransactionRule;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class TimeAndMoneyAwardAmountTransactionRuleImpl
extends ResearchDocumentRuleBase
implements TimeAndMoneyAwardAmountTransactionRule {
    private static final String NEW_AWARD_AMOUNT_TRANSACTION = "newAwardAmountTransaction";
    private static final String TRANSACTION_TYPE_CODE = ".transactionTypeCode";
    private static final String AMOUNTS_INVALID_FROM_TRANSACTIONS = "document.pendingTransactionsCauseErrors";
    private AwardVersionService awardVersionService;
    private AwardAmountInfoService awardAmountInfoService;

    @Override
    public boolean processSaveAwardAmountTransactionBusinessRules(TimeAndMoneyAwardAmountTransactionSaveEvent timeAndMoneyAwardAmountTransactionSaveEvent) {
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyAwardAmountTransactionSaveEvent.getDocument();
        boolean valid = true;
        if (!timeAndMoneyDocument.isInitialSave()) {
            if (timeAndMoneyDocument.getAwardAmountTransactions().size() > 0) {
                if (timeAndMoneyDocument.getAwardAmountTransactions().get(0).getTransactionTypeCode() == null) {
                    valid = false;
                    this.reportError("newAwardAmountTransaction.transactionTypeCode", "error.transaction.type.code.required", new String[0]);
                }
            } else if (timeAndMoneyDocument.getNewAwardAmountTransaction() == null || timeAndMoneyDocument.getNewAwardAmountTransaction().getTransactionTypeCode() == null) {
                valid = false;
                this.reportError("newAwardAmountTransaction.transactionTypeCode", "error.transaction.type.code.required", new String[0]);
            }
            if (timeAndMoneyDocument.getPendingTransactions().size() > 0) {
                for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
                    Award award = this.getAwardVersionService().getWorkingAwardVersion(awardHierarchyNode.getValue().getAwardNumber());
                    AwardAmountInfo aai = this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
                    Date obligatedStartDate = awardHierarchyNode.getValue().getCurrentFundEffectiveDate();
                    Date obligatedEndDate = awardHierarchyNode.getValue().getObligationExpirationDate();
                    KualiDecimal obligatedTotal = awardHierarchyNode.getValue().getAmountObligatedToDate();
                    KualiDecimal anticipatedTotal = awardHierarchyNode.getValue().getAnticipatedTotalAmount();
                    for (PendingTransaction pendingTransaction : timeAndMoneyDocument.getPendingTransactions()) {
                        if (pendingTransaction.getProcessedFlag().booleanValue()) continue;
                        if (StringUtils.equals((String)pendingTransaction.getSourceAwardNumber(), (String)award.getAwardNumber())) {
                            anticipatedTotal = (KualiDecimal)anticipatedTotal.subtract((AbstractKualiDecimal)pendingTransaction.getAnticipatedAmount());
                            obligatedTotal = (KualiDecimal)obligatedTotal.subtract((AbstractKualiDecimal)pendingTransaction.getObligatedAmount());
                        }
                        if (!StringUtils.equals((String)pendingTransaction.getDestinationAwardNumber(), (String)award.getAwardNumber())) continue;
                        anticipatedTotal = (KualiDecimal)anticipatedTotal.add((AbstractKualiDecimal)pendingTransaction.getAnticipatedAmount());
                        obligatedTotal = (KualiDecimal)obligatedTotal.add((AbstractKualiDecimal)pendingTransaction.getObligatedAmount());
                    }
                    MessageMap errorMap = GlobalVariables.getMessageMap();
                    errorMap.clearErrorPath();
                    if (obligatedTotal.isGreaterThan((AbstractKualiDecimal)anticipatedTotal)) {
                        valid = false;
                        this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.anticipated.amount.from.transactions", award.getAwardNumber());
                    }
                    if (anticipatedTotal.isNegative()) {
                        valid = false;
                        this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.award.anticipated.negative.from.transactions", award.getAwardNumber());
                    }
                    if (obligatedTotal.isNegative()) {
                        valid = false;
                        this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.award.obligated.negative.from.transactions", award.getAwardNumber());
                    }
                    if (!obligatedTotal.isPositive() || obligatedStartDate != null && obligatedEndDate != null) continue;
                    valid = false;
                    this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.award.obligated.dates.from.transactions", award.getAwardNumber());
                }
            }
        }
        return valid;
    }

    public AwardVersionService getAwardVersionService() {
        if (this.awardVersionService == null) {
            this.awardVersionService = KraServiceLocator.getService(AwardVersionService.class);
        }
        return this.awardVersionService;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        if (this.awardAmountInfoService == null) {
            this.awardAmountInfoService = KraServiceLocator.getService(AwardAmountInfoService.class);
        }
        return this.awardAmountInfoService;
    }
}

