/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.springframework.core.io.Resource;

public class SensitiveFieldResourceLoader {
    private List<String> listOfFields = new ArrayList<String>();

    public static SensitiveFieldResourceLoader getInstance() {
        return SensitiveFieldResourceLoaderHolder.INSTANCE;
    }

    protected SensitiveFieldResourceLoader() {
        Resource fileResource = KraServiceLocator.getAppContext().getResource("classpath:sensitive-fields.txt");
        this.buildList(fileResource);
    }

    private void buildList(Resource resource) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                this.listOfFields.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getSensitiveFields() {
        return this.listOfFields;
    }

    private static class SensitiveFieldResourceLoaderHolder {
        private static final SensitiveFieldResourceLoader INSTANCE = new SensitiveFieldResourceLoader();

        private SensitiveFieldResourceLoaderHolder() {
        }
    }
}

