/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.util;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.kuali.kra.util.SensitiveFieldMatcher;
import org.kuali.kra.util.SensitiveFieldResourceLoader;

public class SensitiveFieldSimpleMatcher
implements SensitiveFieldMatcher {
    public static final String STAR_CONSTANT = "*";
    private Set<String> fields = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    });

    public SensitiveFieldSimpleMatcher() {
        this.addToSortedSet(SensitiveFieldResourceLoader.getInstance().getSensitiveFields());
    }

    private void addToSortedSet(List<String> listOfStrings) {
        for (String str : listOfStrings) {
            if (str.contains(STAR_CONSTANT)) continue;
            this.fields.add(str);
        }
    }

    @Override
    public boolean match(String searchString) {
        return this.fields.contains(searchString);
    }
}

