/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public final class JstlFunctions {
    private static final String SETTING_PARAMS_PROLOG = "Setting params ";
    private static final String PROPERTY_SETTING_EXC_PROLOG = "Could not set property ";
    private static final String IN_PREPOSITION = " in ";
    private static final String VALUES_FINDER_CLASS_EXC_PROLOG = "Could not find valuesFinder class ";
    private static final Log LOG = LogFactory.getLog(JstlFunctions.class);

    private JstlFunctions() {
    }

    public static List getOptionList(String valuesFinderClassName, Map params) {
        return JstlFunctions.setupValuesFinder(valuesFinderClassName, params).getKeyValues();
    }

    private static KeyValuesFinder setupValuesFinder(String valuesFinderClassName, Map<String, Object> params) {
        KeyValuesFinder retval = JstlFunctions.getKeyFinder(valuesFinderClassName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(SETTING_PARAMS_PROLOG + params));
        }
        JstlFunctions.addParametersToFinder(params, retval);
        return retval;
    }

    private static void addParametersToFinder(Map<String, Object> params, KeyValuesFinder finder) {
        if (finder != null && params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                try {
                    BeanUtils.setProperty((Object)finder, (String)entry.getKey(), (Object)entry.getValue());
                }
                catch (Exception e) {
                    JstlFunctions.warn(PROPERTY_SETTING_EXC_PROLOG + entry.getKey(), e);
                    e.printStackTrace();
                }
            }
        }
    }

    private static KeyValuesFinder getKeyFinder(String valuesFinderClassName) {
        KeyValuesFinder retval = null;
        try {
            retval = (KeyValuesFinder)Class.forName(valuesFinderClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            JstlFunctions.warnAboutValueFinderClassExceptions(valuesFinderClassName, e);
        }
        catch (InstantiationException e) {
            JstlFunctions.warnAboutValueFinderClassExceptions(valuesFinderClassName, e);
        }
        catch (IllegalAccessException e) {
            JstlFunctions.warnAboutValueFinderClassExceptions(valuesFinderClassName, e);
        }
        return retval;
    }

    private static void warnAboutValueFinderClassExceptions(String valuesFinderClassName, Exception e) {
        JstlFunctions.warn(VALUES_FINDER_CLASS_EXC_PROLOG + valuesFinderClassName, e);
    }

    private static void warn(String message, Exception e) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)new StringBuilder(message).append(IN_PREPOSITION).append(JstlFunctions.buildTraceMessage(e)));
        }
    }

    private static String buildTraceMessage(Throwable thrownObj) {
        StackTraceElement stackTraceElement = thrownObj.getStackTrace()[0];
        return stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + " " + thrownObj.getClass().getSimpleName() + "\n" + thrownObj.getMessage();
    }

    public static BigDecimal getBigDecimal(BudgetDecimal budgetDecimal) {
        return budgetDecimal.bigDecimalValue();
    }
}

