/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.filter;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PerformanceFilterResponse
extends HttpServletResponseWrapper {
    private static final String CONTENT_LENGTH = "CONTENT-LENGTH";
    private static final int OK_STATUS = 200;
    private static final String OK_MSG = "OK";
    private int statusCode;
    private String message;
    private Map<String, String> headers = new TreeMap<String, String>();

    public PerformanceFilterResponse(HttpServletResponse response) {
        super(response);
    }

    public int getStatusCode() {
        return this.statusCode == 0 ? 200 : this.statusCode;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = this.statusCode == 200 || this.statusCode == 0 ? OK_MSG : "";
        }
        return this.message;
    }

    public int getContentLength() {
        try {
            return this.headers.containsKey(CONTENT_LENGTH) ? Integer.valueOf(this.headers.get(CONTENT_LENGTH)) : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.headers.put(name, value);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.headers.put(name, String.valueOf(value));
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.headers.put(name, value);
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        this.statusCode = sc;
        this.message = msg;
    }

    public void sendError(int sc) throws IOException {
        super.sendError(sc);
        this.statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        this.statusCode = sc;
        this.message = sm;
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.statusCode = sc;
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.headers.put(name, String.valueOf(value));
    }
}

