/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceLoggingFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(PerformanceLoggingFilter.class);

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long start = System.currentTimeMillis();
        long startMem = Runtime.getRuntime().freeMemory();
        chain.doFilter(request, response);
        if (LOG.isInfoEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            LOG.info((Object)(((HttpServletRequest)request).getRequestURI() + " : " + elapsed + " ms"));
            LOG.info((Object)(((HttpServletRequest)request).getRequestURI() + " : " + usedMemory + " memory used"));
        }
    }
}

