/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.web.filter.PerformanceFilterResponse;

public class PerformanceMeasurementFilter
implements Filter {
    private FilterConfig filterConfig;
    private Calendar _performanceLogCalendar;

    public void destroy() {
        this.setPerformanceLogCalendar(null);
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        PerformanceFilterResponse filterResponse = new PerformanceFilterResponse((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)filterResponse);
        try {
            this.processResponse(request, filterResponse, startTime);
        }
        catch (Throwable t) {
            Log logger = LogFactory.getLog(PerformanceMeasurementFilter.class);
            logger.error((Object)t.getMessage(), t);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.setPerformanceLogCalendar(this.getDateOnlyCalendar());
    }

    private String getPerformanceLogFileName() {
        Calendar todayCalendar = this.getDateOnlyCalendar();
        if (this.isNewFileNeeded(todayCalendar)) {
            this.setPerformanceLogCalendar(todayCalendar);
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        return "Real-time Performance Log " + dateFormatter.format(this.getPerformanceLogCalendar().getTime()) + ".xml";
    }

    private boolean isNewFileNeeded(Calendar todayCalendar) {
        return todayCalendar.get(5) != this.getPerformanceLogCalendar().get(5);
    }

    private Calendar getDateOnlyCalendar() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private synchronized Calendar getPerformanceLogCalendar() {
        return this._performanceLogCalendar;
    }

    private void logSample(HttpSample sample, String outputDirectory) {
        try {
            File file = new File(outputDirectory, this.getPerformanceLogFileName());
            if (!file.exists()) {
                this.createNewFile(file);
            }
            this.insertLine(file, sample);
        }
        catch (Exception e) {
            Log logger = LogFactory.getLog(PerformanceMeasurementFilter.class);
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void processResponse(ServletRequest request, PerformanceFilterResponse response, long startTime) {
        int elapsedTime = (int)(System.currentTimeMillis() - startTime);
        final String outputDirectory = this.filterConfig.getServletContext().getInitParameter("org.kuali.kra.perftest.REPORT_DIRECTORY");
        final HttpSample httpSample = new HttpSample((HttpServletRequest)request, response, outputDirectory, startTime, elapsedTime);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PerformanceMeasurementFilter.this.logSample(httpSample, outputDirectory);
            }
        });
        t.start();
    }

    private synchronized void setPerformanceLogCalendar(Calendar performanceLogCalendar) {
        this._performanceLogCalendar = performanceLogCalendar;
    }

    private void createNewFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        writer.write("<!-- Performance Log File: ");
        writer.write(file.getName());
        writer.write(" -->\n\n");
        writer.write("<httpSamples>");
        writer.write("\n</httpSamples>");
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertLine(File file, HttpSample httpSample) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.skipBytes((int)(file.length() - (long)"\n</httpSamples>".getBytes().length));
            randomAccessFile.write("\n".getBytes());
            randomAccessFile.write(httpSample.toXML().getBytes());
            randomAccessFile.write("\n".getBytes());
            randomAccessFile.write("</httpSamples>".getBytes());
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    private class HttpSample {
        private int responseContentLength;
        private String dataType;
        private String sampleName;
        private String returnMessage;
        private int returnCode;
        private String label;
        private boolean success;
        private long requestTimeStamp;
        private int latency;
        private int elapsedTime;

        public HttpSample(HttpServletRequest request, PerformanceFilterResponse response, String outputDirectory, long startTime, int elapsedTime) {
            this.init(request, response, startTime, elapsedTime);
        }

        public int getResponseContentLength() {
            return this.responseContentLength;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getSampleName() {
            return this.sampleName;
        }

        public String getReturnMessage() {
            return this.returnMessage;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public long getRequestTimeStamp() {
            return this.requestTimeStamp;
        }

        public int getLatency() {
            return this.latency;
        }

        public int getElapsedTime() {
            return this.elapsedTime;
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder("<httpSample");
            this.addAttribute(sb, "t", this.elapsedTime);
            this.addAttribute(sb, "lt", this.latency);
            this.addAttribute(sb, "ts", this.requestTimeStamp);
            this.addAttribute(sb, "s", this.success);
            this.addAttribute(sb, "lb", this.label);
            this.addAttribute(sb, "rc", this.returnCode);
            this.addAttribute(sb, "rm", this.returnMessage);
            this.addAttribute(sb, "tn", this.sampleName);
            this.addAttribute(sb, "dt", this.dataType);
            this.addAttribute(sb, "by", this.responseContentLength);
            sb.append(" />");
            return sb.toString();
        }

        private void addAttribute(StringBuilder sb, String attributeName, Object attributeValue) {
            sb.append(" ");
            sb.append(attributeName);
            sb.append("=\"");
            sb.append(attributeValue);
            sb.append("\"");
        }

        private String getRequestLabel(HttpServletRequest request) {
            StringBuilder sb = new StringBuilder();
            sb.append(request.getServletPath().substring(1));
            String methodToCall = request.getParameter("methodToCall");
            if (methodToCall != null) {
                this.addMethodToCall(sb, methodToCall);
            } else {
                Enumeration nameEnum = request.getParameterNames();
                while (nameEnum.hasMoreElements()) {
                    String parmName = (String)nameEnum.nextElement();
                    if (!parmName.startsWith("methodToCall.")) continue;
                    this.addMethodToCall(sb, parmName.substring("methodToCall.".length()));
                    break;
                }
            }
            return sb.toString();
        }

        private void addMethodToCall(StringBuilder sb, String methodToCall) {
            sb.append(";methodToCall=");
            sb.append(methodToCall);
        }

        private void init(HttpServletRequest request, PerformanceFilterResponse response, long startTime, int elapsedTime) {
            this.responseContentLength = response.getContentLength();
            this.dataType = response.getContentType() != null ? response.getContentType().substring(0, response.getContentType().indexOf("/")) : "text";
            this.sampleName = "Real-time Performance Sample";
            this.returnCode = response.getStatusCode();
            this.returnMessage = response.getMessage();
            this.label = this.getRequestLabel(request);
            this.success = this.returnCode == 0 || this.returnCode == 200 || this.returnCode > 200 && this.returnCode <= 399;
            this.requestTimeStamp = startTime;
            this.elapsedTime = elapsedTime;
            this.latency = elapsedTime;
        }
    }
}

