/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.service.ProposalLockService;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.kra.web.struts.form.BudgetVersionFormBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetActionBase
extends KraTransactionalDocumentActionBase {
    protected static final String COPY_BUDGET_PERIOD_QUESTION = "copyBudgetQuestion";
    protected static final String QUESTION_TYPE = "copyPeriodsQuestion";
    protected static final String QUESTION_TEXT = "A new version of the budget will be created based on version ";

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetVersionFormBase proposalForm = (BudgetVersionFormBase)form;
        ActionForward forward = super.save(mapping, form, request, response);
        return forward;
    }

    protected void setFinalBudgetVersion(Integer finalBudgetVersion, List<BudgetVersionOverview> budgetVersions) {
        for (BudgetVersionOverview budgetVersion : budgetVersions) {
            if (budgetVersion.getBudgetVersionNumber().equals(finalBudgetVersion)) {
                budgetVersion.setFinalVersionFlag(true);
                continue;
            }
            budgetVersion.setFinalVersionFlag(false);
        }
    }

    protected Integer getFinalBudgetVersion(List<BudgetDocumentVersion> budgetVersions) {
        for (BudgetDocumentVersion budgetVersion : budgetVersions) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            return budgetVersion.getBudgetVersionOverview().getBudgetVersionNumber();
        }
        return null;
    }

    protected void setBudgetParentStatus(BudgetParentDocument parentDocument) {
        for (BudgetDocumentVersion budgetVersion : parentDocument.getBudgetDocumentVersions()) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            parentDocument.getBudgetParent().setBudgetStatus(budgetVersion.getBudgetVersionOverview().getBudgetStatus());
            return;
        }
    }

    protected void setBudgetStatuses(BudgetParentDocument proposalDevelopmentDocument) {
        for (BudgetDocumentVersion budgetDocumentVersion : proposalDevelopmentDocument.getBudgetDocumentVersions()) {
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            if (budgetVersion.isFinalVersionFlag()) {
                budgetVersion.setBudgetStatus(proposalDevelopmentDocument.getBudgetParent().getBudgetStatus());
                continue;
            }
            String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
            budgetVersion.setBudgetStatus(budgetStatusIncompleteCode);
        }
    }

    protected void copyBudget(BudgetParentDocument budgetParentDocument, BudgetVersionOverview budgetToCopy, boolean copyPeriodOneOnly) throws WorkflowException {
        DocumentService documentService = KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocToCopy = (BudgetDocument)documentService.getByDocumentHeaderId(budgetToCopy.getDocumentNumber());
        Budget budget = budgetDocToCopy.getBudget();
        BudgetCommonService<BudgetParent> budgetService = this.getBudgetCommonService(budgetParentDocument);
        BudgetDocument<BudgetParent> newBudgetDoc = budgetService.copyBudgetVersion(budgetDocToCopy, copyPeriodOneOnly);
        budgetParentDocument.refreshBudgetDocumentVersions();
        List budgetVersions = budgetParentDocument.getBudgetDocumentVersions();
        for (BudgetDocumentVersion budgetDocumentVersion : budgetVersions) {
            BudgetVersionOverview versionOverview = budgetDocumentVersion.getBudgetVersionOverview();
            if (versionOverview.getBudgetVersionNumber().intValue() != budget.getBudgetVersionNumber().intValue()) continue;
            versionOverview.setDescriptionUpdatable(true);
            versionOverview.setDocumentDescription(budgetToCopy.getDocumentDescription() + " " + budgetToCopy.getBudgetVersionNumber() + " copy");
        }
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParentDocument parentBudgetDocument) {
        return BudgetCommonServiceFactory.createInstance(parentBudgetDocument);
    }

    protected void populateTabState(KualiForm form, String tabTitle) {
        form.getTabStates().put(WebUtils.generateTabKey((String)tabTitle), "OPEN");
    }

    protected PessimisticLockService getPessimisticLockService() {
        return KraServiceLocator.getService(ProposalLockService.class);
    }

    @Override
    protected void setupPessimisticLockMessages(Document document, HttpServletRequest request) {
        super.setupPessimisticLockMessages(document, request);
        List lockMessages = (List)request.getAttribute("DocumentPessimisticLockMessages");
        BudgetDocument budgetDoc = (BudgetDocument)document;
        for (PessimisticLock lock : budgetDoc.getParentDocument().getPessimisticLocks()) {
            String message;
            if (!StringUtils.contains((String)lock.getLockDescriptor(), (String)"BUDGET") || lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson()) || lockMessages.contains(message = this.generatePessimisticLockMessage(lock))) continue;
            lockMessages.add(message);
        }
        request.setAttribute("DocumentPessimisticLockMessages", (Object)lockMessages);
    }
}

