/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.web.struts.action.AuditMapSorter;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.web.struts.action.KualiRequestProcessor;
import org.kuali.rice.krad.util.GlobalVariables;

public class KraRequestProcessor
extends KualiRequestProcessor {
    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        super.processPreprocess(request, response);
        Object campusCode = request.getSession().getAttribute("userCampusCode");
        GlobalVariables.getUserSession().addObject("userCampusCode", campusCode);
        return true;
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        ActionForward actionForward;
        if (this.isSessionExpired(request)) {
            HttpSession session = request.getSession();
            session.removeAttribute("sessionExpired");
            actionForward = mapping.findForward("portal");
        } else {
            actionForward = super.processActionPerform(request, response, action, form, mapping);
            this.sortAuditMapInRequest(request);
        }
        return actionForward;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        if (!this.isSessionExpired(request)) {
            super.processPopulate(request, response, form, mapping);
        }
    }

    private boolean isSessionExpired(HttpServletRequest request) {
        assert (request != null) : "the request is null";
        HttpSession session = request.getSession();
        Boolean sessionExpired = (Boolean)session.getAttribute("sessionExpired");
        return Boolean.TRUE.equals(sessionExpired);
    }

    private Map<String, AuditCluster> getAuditMap(HttpServletRequest request) {
        assert (request != null) : "the request is null";
        Map auditErrorsMap = (Map)request.getAttribute("AuditErrors");
        return auditErrorsMap;
    }

    private void sortAuditMapInRequest(HttpServletRequest request) {
        assert (request != null) : "the request is null";
        Map<String, AuditCluster> auditMap = this.getAuditMap(request);
        if (auditMap != null) {
            AuditMapSorter sorter = new AuditMapSorter(auditMap);
            sorter.sort(AuditMapSorter.DEFAULT_PATTERN_COMPARATOR_MAP);
        }
    }
}

