/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public abstract class AbstractProjectPersonDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected abstract List<? extends AbstractProjectPerson> getProjectPersons(Map<String, String> var1);

    protected void filterListByRole(List<? extends AbstractProjectPerson> persons, String roleName) {
        if (StringUtils.equals((String)roleName, (String)"PI") || StringUtils.equals((String)roleName, (String)"COI") || StringUtils.equals((String)roleName, (String)"KP")) {
            Iterator<? extends AbstractProjectPerson> iter = persons.iterator();
            while (iter.hasNext()) {
                AbstractProjectPerson person = iter.next();
                if (StringUtils.equals((String)person.getRoleCode(), (String)roleName)) continue;
                iter.remove();
            }
        }
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        List<? extends AbstractProjectPerson> projectPersons = this.getProjectPersons(qualification);
        String subQualification = qualification.get("subQualifier");
        if (projectPersons != null && !projectPersons.isEmpty()) {
            this.filterListByRole(projectPersons, roleName);
            if (StringUtils.isNotBlank((String)subQualification)) {
                this.filterListByRole(projectPersons, subQualification);
            }
            for (AbstractProjectPerson abstractProjectPerson : projectPersons) {
                if (abstractProjectPerson.getPerson() == null) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)abstractProjectPerson.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        List<RoleMembership> members = this.getRoleMembersFromDerivedRole(namespaceCode, roleName, qualification);
        for (RoleMembership member : members) {
            if (!StringUtils.equals((String)member.getMemberId(), (String)principalId)) continue;
            return true;
        }
        return false;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }
}

