/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeScheduleService;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ActiveCommitteeMemberOnScheduledDateDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private CommitteeService committeeService;
    private CommitteeScheduleService committeeScheduleService;
    private static final Logger LOG = Logger.getLogger(ActiveCommitteeMemberOnScheduledDateDerivedRoleTypeServiceImpl.class);
    private static final String DEFAULT_QUALIFYING_COMMITTEE_MEMBERSHIP_TYPE_CODE = "1";
    protected Set<String> qualifyingCommitteeMembershipTypeCodes;
    protected List<String> requiredAttributes = new ArrayList<String>();

    public ActiveCommitteeMemberOnScheduledDateDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("committee");
        this.requiredAttributes.add("committeeSchedule");
    }

    public void init() {
        if (this.qualifyingCommitteeMembershipTypeCodes == null) {
            LOG.info((Object)String.format("No qualifying committee membership type codes were specified, defaulting to type code %s.", DEFAULT_QUALIFYING_COMMITTEE_MEMBERSHIP_TYPE_CODE));
            this.qualifyingCommitteeMembershipTypeCodes = new HashSet<String>();
            this.qualifyingCommitteeMembershipTypeCodes.add(DEFAULT_QUALIFYING_COMMITTEE_MEMBERSHIP_TYPE_CODE);
        }
    }

    private boolean isQualified(CommitteeMembership membership, CommitteeSchedule schedule, Map<String, String> qualification) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Checking qualification of membership:%s", membership));
        }
        boolean result = true;
        if (this.qualifyingCommitteeMembershipTypeCodes.size() > 0) {
            if (LOG.isDebugEnabled() && !this.qualifyingCommitteeMembershipTypeCodes.contains(membership.getMembershipTypeCode())) {
                LOG.debug((Object)String.format("Membership %s does not have membership type code in the qualifying map.", new Object[0]));
            }
            result &= this.qualifyingCommitteeMembershipTypeCodes.contains(membership.getMembershipTypeCode());
        }
        boolean isActiveOnScheduledDate = false;
        if (schedule.getScheduledDate() != null) {
            isActiveOnScheduledDate = membership.isActive(schedule.getScheduledDate());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("isActive for schedule %s returns %s", schedule, isActiveOnScheduledDate));
        }
        return result &= isActiveOnScheduledDate;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String committeeId = qualification.get("committee");
        String scheduleId = qualification.get("committeeSchedule");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Running getRoleMembersFromDerivedRole for committee %s", committeeId));
        }
        if (!StringUtils.isEmpty((String)committeeId) && !StringUtils.isEmpty((String)scheduleId)) {
            Committee committee = (Committee)this.committeeService.getCommitteeById(committeeId);
            CommitteeSchedule schedule = (CommitteeSchedule)this.committeeService.getCommitteeSchedule(committee, scheduleId);
            if (committee != null && schedule != null) {
                for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                    if (!this.isQualified((CommitteeMembership)membership, schedule, qualification)) continue;
                    members.add(RoleMembership.Builder.create(null, null, (String)membership.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)String.format("Adding %s for getRoleMembersFromDerivedRole for committee %s, schedule %s", committeeId, scheduleId));
                }
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String committeeId = qualification.get("committee");
        String scheduleId = qualification.get("committeeSchedule");
        if (!StringUtils.isEmpty((String)committeeId) && !StringUtils.isEmpty((String)scheduleId)) {
            Committee committee = (Committee)this.committeeService.getCommitteeById(committeeId);
            CommitteeSchedule schedule = (CommitteeSchedule)this.committeeService.getCommitteeSchedule(committee, scheduleId);
            if (committee != null && schedule != null) {
                for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                    if (membership.getPersonId() == null || !StringUtils.equals((String)principalId, (String)membership.getPersonId()) || !this.isQualified((CommitteeMembership)membership, schedule, qualification)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public CommitteeService getCommitteeService() {
        return this.committeeService;
    }

    public void setCommitteeService(CommitteeService committeeService) {
        this.committeeService = committeeService;
    }

    public List<String> getQualifiersForExactMatch() {
        ArrayList<String> quals = new ArrayList<String>();
        quals.add("committee");
        quals.add("committeeSchedule");
        return quals;
    }

    public Set<String> getQualifyingCommitteeMembershipTypeCodes() {
        return this.qualifyingCommitteeMembershipTypeCodes;
    }

    public void setQualifyingCommitteeMembershipTypeCodes(Set<String> qualifyingCommitteeMembershipTypeCodes) {
        this.qualifyingCommitteeMembershipTypeCodes = qualifyingCommitteeMembershipTypeCodes;
    }

    public CommitteeScheduleService getCommitteeScheduleService() {
        return this.committeeScheduleService;
    }

    public void setCommitteeScheduleService(CommitteeScheduleService committeeScheduleService) {
        this.committeeScheduleService = committeeScheduleService;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

