<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 sp2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:PHS398_TrainingBudget="http://apply.grants.gov/forms/PHS398_TrainingBudget-V1.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.25in" margin-right="0.25in">
				<fo:region-body margin-top="0" margin-bottom="0"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="PHS398_TrainingBudget:PHS398_TrainingBudget">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<xsl:if test="PHS398_TrainingBudget:BudgetYear">
								<fo:table font-family="Vrinda" line-height="6pt" padding="0" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body margin="0" padding="0" start-indent="0pt">
											<xsl:for-each select="PHS398_TrainingBudget:BudgetYear">
												<fo:table-row margin="0">
													<fo:table-cell margin="0" padding="0" padding-bottom="0" display-align="center">
														<fo:block>
															<fo:inline font-size="5pt">
																<xsl:text>OMB Number: 0925-0001</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row margin="0">
													<fo:table-cell margin="0" padding="0" padding-top="0" text-align="center" display-align="after">
														<fo:block>
															<fo:inline font-weight="bold">
																<xsl:text>PHS 398 TRAINING BUDGET, Period </xsl:text>
															</fo:inline>
															<fo:inline font-weight="bold">
																<xsl:value-of select="position()"/>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row margin="0">
													<fo:table-cell padding-left="25pt" padding-right="25pt" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table font-family="Verdana" font-size="7pt" line-height="6pt" table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-body margin="0" padding="0" start-indent="0pt">
																	<fo:table-row margin="0">
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-family="Verdana" font-size="7pt">
																					<xsl:text>Organizational DUNS: </xsl:text>
																				</fo:inline>
																					<xsl:for-each select="//PHS398_TrainingBudget:PHS398_TrainingBudget">
																						<xsl:for-each select="PHS398_TrainingBudget:DUNSNumber">
																							<fo:inline>
																								<xsl:text>&#160; </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline>
																					<xsl:text>Budget Type:</xsl:text>
																				</fo:inline>
																					<xsl:for-each select="//PHS398_TrainingBudget:PHS398_TrainingBudget">	
																						<xsl:for-each select="PHS398_TrainingBudget:BudgetType">
																							<fo:inline>
																								<xsl:text>&#160;&#160; </xsl:text>
																							</fo:inline>
																							<xsl:choose>
																								<xsl:when test="string(.)='Project'">
																									<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																										<xsl:text>&#x2714;</xsl:text>
																									</fo:inline>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline border="solid 1pt black">
																										<fo:leader leader-length="10pt" leader-pattern="space"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																							<fo:inline>
																								<xsl:text> Project&#160;&#160;&#160;&#160;&#160; </xsl:text>
																							</fo:inline>
																							<xsl:choose>
																								<xsl:when test="string(.)='Subaward/Consortium'">
																									<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																										<xsl:text>&#x2714;</xsl:text>
																									</fo:inline>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline border="solid 1pt black">
																										<fo:leader leader-length="10pt" leader-pattern="space"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																							<fo:inline>
																								<xsl:text> Subaward/Consortium</xsl:text>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row margin="0">
																		<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-family="Verdana" font-size="7pt">
																					<xsl:text>Organization Name:</xsl:text>
																				</fo:inline>
																					<xsl:for-each select="//PHS398_TrainingBudget:PHS398_TrainingBudget">
																						<xsl:for-each select="PHS398_TrainingBudget:OrganizationName">
																							<fo:inline>
																								<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row line-height="3pt" margin="0" padding="0" padding-bottom="0" padding-top="0">
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block>
																				<fo:inline>
																					<xsl:text>Start Date:</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="PHS398_TrainingBudget:PeriodStartDate">
																					<fo:inline>
																						<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																					</fo:inline>
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block>
																				<fo:inline>
																					<xsl:text>End Date:</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="PHS398_TrainingBudget:PeriodEndDate">
																					<fo:inline>
																						<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
																					</fo:inline>
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block/>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row margin="0">
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row margin="0">
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-body start-indent="0pt">
																	<fo:table-row>
																		<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:table font-family="Verdana" font-size="7pt" line-height="6pt" table-layout="fixed" width="100%" border-spacing="2pt">
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-column column-width="proportional-column-width(1)"/>
																					<fo:table-body start-indent="0pt">
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="6" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>A. Stipends, Tuition/Fees</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline text-decoration="underline">
																										<xsl:text>Number of Trainees</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Full</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Time</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Short</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Term</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Stipends</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Requested ($)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Tuition/Fees</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Requested ($)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:UndergraduateNumFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:UndergraduateNumShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline text-decoration="underline">
																										<xsl:text>Undergraduate:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:UndergraduateStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:UndergraduateTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Number Per Stipend Level:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>First-Year/Soph.</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:UndergraduateNumFirstYearSophomoreStipends">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Junior/Senior</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:UndergraduateNumJuniorSeniorStipends">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocSingleDegreeNumFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocSingleDegreeNumShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Predoctoral:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Single Degree</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocSingleDegreeStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocSingleDegreeTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocDualDegreeNumFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocDualDegreeNumShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Dual Degree</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocDualDegreeStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocDualDegreeTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocTotalNumFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocTotalNumShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Total Predoctoral</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocTotalStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PredocTotalTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline text-decoration="underline">
																										<xsl:text>Postdoctoral:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="5" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Number Per Stipend Level:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>0</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>1</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>2</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>3</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>4</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>5</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>6</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>7</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Non-degree</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Seeking</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel0">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel1">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel2">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel3">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel4">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel5">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel6">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumNonDegreeStipendLevel7">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNonDegreeStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNonDegreeTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Degree</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Seeking</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel0">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel1">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel2">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel3">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel4">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel5">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel6">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocNumDegreeStipendLevel7">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocDegreeStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocDegreeTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Total</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline font-weight="bold">
																										<xsl:text>Postdoctoral</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel0">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel1">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel2">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel3">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel4">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel5">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel6">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendLevel7">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:PostdocTotalTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:OtherNumFullTime">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:OtherNumShortTerm">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline text-decoration="underline">
																										<xsl:text>Other:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:OtherStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:OtherTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="2" padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Totals:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalStipendsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalTuitionAndFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="6" padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Total Stipends + Tuition/Fees Requested</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalStipendsAndTuitionFeesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>B. Other Direct Costs</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Funds Requested ($)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="7" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Trainee Travel</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TraineeTravelRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="6" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Training Related Expenses</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TrainingRelatedExpensesRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="7" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Total Direct Costs from R&amp;R Budget Form (if applicable)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:ResearchDirectCostsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="6" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Consortium Training Costs (if applicable)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:ConsortiumTrainingCostsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="5" padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Total Other Direct Costs Requested</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalOtherDirectCostsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="7" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>C. Total Direct Costs Requested (A + B)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalDirectCostsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="before">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>D. Indirect Costs</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Indirect Cost Type</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="2" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Indirect Cost</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Rate (%)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Indirect Cost</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Base ($)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>Funds</xsl:text>
																									</fo:inline>
																									<fo:block/>
																									<fo:inline>
																										<xsl:text>Requested ($)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>1.</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="10" number-rows-spanned="2" padding="2pt" display-align="before">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostType1">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostRate1">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostBase1">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostFundsRequested1">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" text-align="center" display-align="center">
																								<fo:block>
																									<fo:inline>
																										<xsl:text>2.</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="10" number-rows-spanned="2" padding="2pt" display-align="before">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostType2">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostRate2">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostBase2">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:IndirectCostFundsRequested2">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="6" padding="2pt" text-align="right" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Total Indirect Costs Requested</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalIndirectCostsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="8" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>E. Total Direct and Indirect Costs Requested (C + D)</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block/>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="PHS398_TrainingBudget:TotalDirectAndIndirectCostsRequested">
																															<fo:inline>
																																<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																															</fo:inline>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:block text-align="center">
																										<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																									</fo:block>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell number-columns-spanned="5" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>F. Budget Justification</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell number-columns-spanned="16" padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table line-height="6pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																										<fo:table-column column-width="proportional-column-width(1)"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline>
																															<xsl:text>&#160;</xsl:text>
																														</fo:inline>
																														<xsl:for-each select="//PHS398_TrainingBudget:PHS398_TrainingBudget">
																															<xsl:for-each select="PHS398_TrainingBudget:BudgetJustification">
																																	<xsl:for-each select="att:FileName">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates/>
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</xsl:for-each>																															
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</fo:table-body>
																				</fo:table>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row margin="0">
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-family="Verdana" font-size="7pt">
																<xsl:text>&#160;</xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table line-height="6pt" table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-body margin="0" padding="0" start-indent="0pt">
																	<fo:table-row margin="0">
																		<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																			<fo:block/>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
															<fo:block break-after="page">
																<fo:leader leader-pattern="space"/>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</xsl:for-each>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Verdana" font-size="7pt" margin="0" padding="0" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" text-align="center" display-align="center">
											<fo:block>
												<fo:block/>
												<fo:block/>
												<fo:inline font-size="medium" font-weight="bold">
													<xsl:text>PHS 398 TRAINING BUDGET, Cumulative Budget</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table margin="0" padding="0" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table padding-left="3pt" table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="5%"/>
																		<fo:table-column column-width="10%"/>
																		<fo:table-column column-width="35%"/>
																		<fo:table-column column-width="25%"/>
																		<fo:table-column column-width="25%"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>A. Stipends, Tuition/Fees</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" text-align="center" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Stipends</xsl:text>
																						</fo:inline>
																						<fo:block/>
																						<fo:inline>
																							<xsl:text>Requested ($)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" text-align="center" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Tuition/Fees</xsl:text>
																						</fo:inline>
																						<fo:block/>
																						<fo:inline>
																							<xsl:text>Requested ($)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Undergraduate:</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeUndergraduateStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeUndergraduateTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Predoctoral:</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Single Degree</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePredocSingleDegreeStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePredocSingleDegreeTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Dual Degree</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePredocDualDegreeStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePredocDualDegreeTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Total Predoctoral</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePredocTotalStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePredocTotalTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Postdoctoral:</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Non-Degree Seeking</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePostdocNonDegreeStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePostdocNonDegreeTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Degree Seeking</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePostdocDegreeStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePostdocDegreeTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" height="15" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" height="15" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" height="15" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Total Postdoctoral</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" height="15" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePostdocTotalStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" height="15" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativePostdocTotalTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Other:</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeOtherStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeOtherTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" text-align="right" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Totals:&#160;&#160;&#160; </xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTotalStipendsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTuitionAndFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="2" padding="2pt" text-align="right" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Total Stipends + Tuition/Fees Requested&#160;&#160;&#160; </xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTotalStipendsAndTuitionFeesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="5" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:block text-align="center">
																							<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																						</fo:block>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>B. Other Direct Costs</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" text-align="center" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Funds</xsl:text>
																						</fo:inline>
																						<fo:block/>
																						<fo:inline>
																							<xsl:text>Requested ($)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Trainee Travel</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTraineeTravelRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Training Related Expenses</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTrainingRelatedExpensesRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Total Direct Costs from R&amp;R Budget Form (if applicable)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeResearchDirectCostsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Consortium Training Costs (if applicable)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeConsortiumTrainingCostsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" text-align="right" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Total Other Direct Costs Requested&#160;&#160;&#160; </xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTotalOtherDirectCostsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="5" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:block text-align="center">
																							<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																						</fo:block>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>C. Total Direct Costs Requested (A + B)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTotalDirectCostsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="5" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:block text-align="center">
																							<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																						</fo:block>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>D. Total Indirect Costs Requested</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTotalIndirectCostsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="5" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:block text-align="center">
																							<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																						</fo:block>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell number-columns-spanned="4" padding="2pt" height="7" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>E. Total Direct and Indirect Costs Requested (C + D)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" height="7" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>																											
																												<xsl:for-each select="PHS398_TrainingBudget:CumulativeTotalDirectAndIndirectCostsRequested">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																													</fo:inline>
																												</xsl:for-each>																											
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>						
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
