/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.award.awardhierarchy.sync;

import org.apache.commons.lang.StringUtils;

/**
 * Enum with the types of logs that award sync can generate.
 */
public enum AwardSyncLogType {

    CHANGE_LOG("CL", "Change"), VALIDATION_MESSAGE("VM", "Validation Message");
    private String code;
    private String desc;
    private AwardSyncLogType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    public String getCode() {
        return code;
    }
    public String getDesc() {
        return desc;
    }
    public static AwardSyncLogType getLogTypeFromCode(String code) {
        for (AwardSyncLogType type : AwardSyncLogType.values()) {
            if (StringUtils.equals(code, type.getCode())) {
                return type;
            }
        }
        return null;
    }
    
}
