/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.award.commitments;

import java.util.List;

import org.kuali.kra.award.home.ValidRates;


/**
 * 
 * This is the AwardFandaRateService interface.
 */
public interface AwardFandaRateService {
    
    /**
     * 
     * This method returns the start and end dates for a given fiscal year.
     * The Start Date for a fiscal year would be 07/01/<fiscalYear-1> and 
     * End Date would be 06/30/<fiscalYear> 
     * @param fiscalYear
     * @return
     */
    public List<String> getStartAndEndDatesBasedOnFiscalYear(String fiscalYear);
    
    public List<ValidRates> getValidRates(AwardFandaRate awardFandaRate);
    
}
