/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.osedu.org/licenses/ECL-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.committee.document.authorization;

import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeDocumentAuthorizerBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.infrastructure.TaskGroupName;
import org.kuali.kra.infrastructure.TaskName;

/**
 * This class is the Committee Document Authorizer.  It determines the edit modes and
 * document actions for all committee documents.
 */
public class CommitteeDocumentAuthorizer extends CommitteeDocumentAuthorizerBase {

    /**
     * Comment for <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = 6464453088283772104L;

    @Override
    protected String getAddCommitteeTaskNameHook() {
        return TaskName.ADD_COMMITTEE;
    }

    @Override
    protected CommitteeTaskBase getNewCommitteeTaskInstanceHook(String taskName, CommitteeBase committee) {
        return new CommitteeTaskBase<Committee>(TaskGroupName.COMMITTEE, taskName, (Committee) committee) {};
    }

// TODO ********************** commented out during IRB backfit ************************    
//    /**
//     * @see org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizer#getEditModes(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person, java.util.Set)
//     */
//    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
//        Set<String> editModes = new HashSet<String>();
//        String userId = user.getPrincipalId();
//        CommitteeDocument committeeDocument = (CommitteeDocument) document;
//        if (committeeDocument.getCommittee().getCommitteeId() == null) {
//            if (canCreateCommittee(user)) {
//                editModes.add(AuthorizationConstants.EditMode.FULL_ENTRY);
//            } 
//            else {
//                editModes.add(AuthorizationConstants.EditMode.UNVIEWABLE);
//            }
//        } 
//        else {
//            if (canExecuteCommitteeTask(userId, committeeDocument, TaskName.MODIFY_COMMITTEE)) {  
//                editModes.add(AuthorizationConstants.EditMode.FULL_ENTRY);
//            }
//            else if (canExecuteCommitteeTask(userId, committeeDocument, TaskName.VIEW_COMMITTEE)) {
//                editModes.add(AuthorizationConstants.EditMode.VIEW_ONLY);
//            }
//            else {
//                editModes.add(AuthorizationConstants.EditMode.UNVIEWABLE);
//            }
//        }
//        
//        return editModes;
//    }
//    
//    /**
//     * @see org.kuali.rice.kns.document.authorization.DocumentAuthorizer#canInitiate(java.lang.String, org.kuali.rice.kim.api.identity.Person)
//     */
//    public boolean canInitiate(String documentTypeName, Person user) { 
//        return canCreateCommittee(user);
//    }
//    
//    /**
//     * @see org.kuali.rice.kns.document.authorization.DocumentAuthorizer#canOpen(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    public boolean canOpen(Document document, Person user) {
//        CommitteeDocument committeeDocument = (CommitteeDocument) document;
//        if (committeeDocument.getCommittee().getCommitteeId() == null) {
//            return canCreateCommittee(user);
//        }
//        return canExecuteCommitteeTask(user.getPrincipalId(), (CommitteeDocument) document, TaskName.VIEW_COMMITTEE);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canEdit(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canEdit(Document document, Person user) {
//        return !isFinal(document) &&
//               canExecuteCommitteeTask(user.getPrincipalId(), (CommitteeDocument) document, TaskName.MODIFY_COMMITTEE);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canSave(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canSave(Document document, Person user) {
//        return canEdit(document, user);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canRoute(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canRoute(Document document, Person user) {
//        return !isFinal(document) && super.canRoute(document, user);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canBlanketApprove(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canBlanketApprove(Document document, Person user) {
//        return !isFinal(document) && super.canBlanketApprove(document, user);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canCancel(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canCancel(Document document, Person user) {
//        return !isFinal(document) && super.canCancel(document, user);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canAcknowledge(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canAcknowledge(Document document, Person user) {
//        return false;
//    }
//    
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canApprove(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canApprove(Document document, Person user) {
//        return false;
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canDisapprove(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canDisapprove(Document document, Person user) {
//        return false;
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canReload(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canReload(Document document, Person user) {
//        return isFinal(document);
//    }
//    
//    /**
//     * @see org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase#canCopy(org.kuali.rice.krad.document.Document, org.kuali.rice.kim.api.identity.Person)
//     */
//    @Override
//    public boolean canCopy(Document document, Person user) {
//        return false;
//    }
//    
//    /**
//     * Does the user have permission to create a committee?
//     * @param user the user
//     * @return true if the user can create a committee; otherwise false
//     */
//    private boolean canCreateCommittee(Person user) {
//        ApplicationTask task = new ApplicationTask(TaskName.ADD_COMMITTEE);       
//        return getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), task);
//    }
//    
//    /**
//     * Does the user have permission to execute the given task for a committee?
//     * @param username the user's username
//     * @param doc the committee document
//     * @param taskName the name of the task
//     * @return true if has permission; otherwise false
//     */
//    private boolean canExecuteCommitteeTask(String userId, CommitteeDocument doc, String taskName) {
//        CommitteeTask task = new CommitteeTask(taskName, doc.getCommittee());       
//        return getTaskAuthorizationService().isAuthorized(userId, task);
//    }
//
//    /*
//    @Override
//    public boolean canFyi(Document document, Person user) {
//        return false;
//    }
//    */
//    
//    @Override
//    public boolean canSendNoteFyi(Document document, Person user) {
//        return false;
//    }

}
