/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.osedu.org/licenses/ECL-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.committee.lookup.keyvalue;

import org.kuali.kra.common.committee.lookup.keyvalue.CommitteeScheduleValuesFinderBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.committee.service.CommitteeService;

/**
 * Finds the available set of dates where a protocol can be scheduled
 * for a review by a committee.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
public class CommitteeScheduleValuesFinder extends CommitteeScheduleValuesFinderBase {
    
    /**
     * Comment for <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = 338230898950097350L;

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return CommitteeService.class;
    }

// TODO ********************** commented out during IRB backfit ************************    
//    /**
//     * @return the list of &lt;key, value&gt; pairs of committees.  The first entry
//     * is always &lt;"", "select:"&gt;.
//     * @see org.kuali.core.lookup.keyvalues.KeyValuesFinder#getKeyValues()
//     */
//    public List<KeyValue> getKeyValues() {
//        return getCommitteeService().getAvailableCommitteeDates(getCommitteeId());
//    }
//    
//    /**
//     * Get the Committee Service.
//     * @return the Committee Service
//     */
//    private CommitteeService getCommitteeService() {
//        return KraServiceLocator.getService(CommitteeService.class);
//    }
//
//    /**
//     * Get the committee id.  Currently we are only concerned with
//     * scheduling protocols.  The committee id is found in via the ProtocolForm.
//     * Keep in mind that the user selects the committee via a drop-down and
//     * thus the selected committee id is placed into the form.
//     * @return
//     */
//    private String getCommitteeId() {
//        String committeeId = "";
//        KualiForm form = KNSGlobalVariables.getKualiForm();
//        if (form instanceof ProtocolForm) {
//            ProtocolForm protocolForm = (ProtocolForm) form;
//            committeeId = protocolForm.getActionHelper().getProtocolSubmitAction().getCommitteeId();
//        }
//        return committeeId;
//    }
    
}
