/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.common.committee.web.struts.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDateConflictEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDayEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleFilterEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleStartAndEndDateEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleTimeEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleWeekDayEvent;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeScheduleEventBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleEventBase.ErrorType;
import org.kuali.kra.common.committee.rules.CommitteeScheduleDataDictionaryValidationRule;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kns.question.ConfirmationQuestion;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.KRADConstants;

public abstract class CommitteeScheduleActionBase extends CommitteeActionBase {
    
    @SuppressWarnings("unused")
    private static final org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory.getLog(CommitteeScheduleActionBase.class);
    
    private static final String DELETE_QUESTION = "Are you sure you want to delete?";
    
    private static final String DELETE_QUESTION_ID = "committeeSchedule.delete.question";
        
    public static final boolean FALSE = false;
    
    /**
     * @see org.kuali.kra.common.committee.web.struts.action.CommitteeActionBase#execute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        ActionForward actionForward = super.execute(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        
        return actionForward;
    }    
    
    /**
     * @see org.kuali.kra.common.committee.web.struts.action.CommitteeActionBase#save(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {    
                
        CommitteeFormBase committeeForm = (CommitteeFormBase) form;
        ScheduleData scheduleData = committeeForm.getCommitteeHelper().getScheduleData();
      
        ActionForward actionForward = super.save(mapping, form, request, response);

        scheduleData.populateStyleClass(); 
        return actionForward;
    }    
    
    /**
     * This method us UI hook to add new schedules to list of schedules.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward addEvent(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
 
        CommitteeFormBase committeeForm = (CommitteeFormBase) form;
        ScheduleData scheduleData = committeeForm.getCommitteeHelper().getScheduleData();
        boolean flag = false;
        
        flag = new CommitteeScheduleDataDictionaryValidationRule().applyRules(scheduleData);
        
        flag &= applyRules(new CommitteeScheduleWeekDayEvent(Constants.EMPTY_STRING, committeeForm.getDocument(), scheduleData, null, ErrorType.HARDERROR));
        
        flag &= applyRules(new CommitteeScheduleDayEvent(Constants.EMPTY_STRING, committeeForm.getDocument(), scheduleData, null, ErrorType.HARDERROR));
        
        flag &= applyRules(new CommitteeScheduleTimeEvent(Constants.EMPTY_STRING, committeeForm.getDocument(), scheduleData, null, ErrorType.HARDERROR));
        
        flag &= applyRules(new CommitteeScheduleStartAndEndDateEvent(Constants.EMPTY_STRING, committeeForm.getDocument(), scheduleData, null, ErrorType.HARDERROR));
        
        if(flag) {
            CommitteeScheduleServiceBase service  = getCommitteeScheduleService();
            service.addSchedule(scheduleData, committeeForm.getCommitteeDocument().getCommittee());            
            applyRules(new CommitteeScheduleDateConflictEvent(Constants.EMPTY_STRING, committeeForm.getDocument(), scheduleData, null, ErrorType.SOFTERROR));
            committeeForm.getCommitteeHelper().prepareView();
        }

        scheduleData.populateStyleClass();        
        return mapping.findForward(Constants.MAPPING_BASIC );
    }

    /**
     * This method is UI hook to delete CommitteeScheduleBase from list.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward deleteCommitteeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request,
            HttpServletResponse response) throws Exception {

        CommitteeFormBase committeeForm = (CommitteeFormBase) form;
        Object question = request.getParameter(KRADConstants.QUESTION_INST_ATTRIBUTE_NAME);
        String methodToCall = committeeForm.getMethodToCall();
        if (question == null) {
            if (applyRules(getNewDeleteCommitteeScheduleEventInstanceHook(Constants.EMPTY_STRING, committeeForm.getDocument(), null, committeeForm.getCommitteeDocument().getCommittee().getCommitteeSchedules(),
                ErrorType.HARDERROR))) {
                return performQuestionWithoutInput(mapping, form, request, response, DELETE_QUESTION_ID, DELETE_QUESTION,
                        KRADConstants.CONFIRMATION_QUESTION, methodToCall, "");
            }
        } else {
            Object buttonClicked = request.getParameter(KRADConstants.QUESTION_CLICKED_BUTTON);
            if ((DELETE_QUESTION_ID.equals(question)) && ConfirmationQuestion.YES.equals(buttonClicked)) {

                List<CommitteeScheduleBase> list = committeeForm.getCommitteeDocument().getCommittee().getCommitteeSchedules();
                List<CommitteeScheduleBase> updatedlist = new ArrayList<CommitteeScheduleBase>(list);
                Collections.copy(updatedlist, list);
                for (CommitteeScheduleBase schedule : list) {
                    if (schedule.isSelected())
                        updatedlist.remove(schedule);
                }
                committeeForm.getCommitteeDocument().getCommittee().setCommitteeSchedules(updatedlist);
            }
        }
        return mapping.findForward(Constants.MAPPING_BASIC);
    }
    
    protected abstract DeleteCommitteeScheduleEventBase getNewDeleteCommitteeScheduleEventInstanceHook(String errorPathPrefix, Document document, ScheduleData scheduleData, List<CommitteeScheduleBase> committeeSchedules, ErrorType type);

    /**
     * This method is UI hook to filter dates in between start and end date.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward filterCommitteeScheduleDates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        
        CommitteeFormBase committeeForm = (CommitteeFormBase) form;  
        
        
        ScheduleData scheduleData = committeeForm.getCommitteeHelper().getScheduleData();
        if(applyRules(new CommitteeScheduleFilterEvent(Constants.EMPTY_STRING, committeeForm.getDocument(), scheduleData, null, ErrorType.HARDERROR))) {
            Date startDate = scheduleData.getFilterStartDate();
            Date endDate = scheduleData.getFilerEndDate();
            committeeForm.getCommitteeHelper().prepareFilterDatesView(startDate, endDate);
        }
        return mapping.findForward(Constants.MAPPING_BASIC );
    }

    /**
     * This method is UI hook to reset filtered dates.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward resetCommitteeScheduleDates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        
        CommitteeFormBase committeeForm = (CommitteeFormBase) form;        
        committeeForm.getCommitteeHelper().resetFilterDatesView();
        return mapping.findForward(Constants.MAPPING_BASIC );
    } 
    
    /**
     * This method is UI hook to load recurrence, in case javascript is turned off on browser.
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward loadRecurrence(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase) form;
        committeeForm.getCommitteeHelper().getScheduleData().populateStyleClass();
        return mapping.findForward(Constants.MAPPING_BASIC );
    }  
    
    /**
     * This method retrieve CommitteeScheduleService.
     * @return
     */
    private CommitteeScheduleServiceBase getCommitteeScheduleService(){
        return KraServiceLocator.getService(getCommitteeScheduleServiceClassHook());
    }
        
    protected abstract Class<? extends CommitteeScheduleServiceBase> getCommitteeScheduleServiceClassHook();
    

    
    public ActionForward maintainSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        
        CommitteeFormBase committeeForm = (CommitteeFormBase) form;     
        CommitteeScheduleBase commSchedule = ((CommitteeDocumentBase<?, ?, ?>)committeeForm.getDocument()).getCommittee().getCommitteeSchedules().get(getLineToDelete(request));
        
// TODO *********commented the code below during IACUC refactoring*********         
//        response.sendRedirect("iacucMeetingManagement.do?methodToCall=start&scheduleId="+commSchedule.getId()+"&lineNum="+(getLineToDelete(request)+1)+"&readOnly=" +(!committeeForm.getCommitteeHelper().canModifySchedule()));

// commented out and replaced with ActionDirect below in order to deal with a rice change that assumes that all action methods will return non-null ActionForward instances.        
//        response.sendRedirect(getMeetingManagementActionIdHook() + ".do?methodToCall=start&scheduleId="+commSchedule.getId()+"&lineNum="+(getLineToDelete(request)+1)+"&readOnly=" +(!committeeForm.getCommitteeHelper().canModifySchedule()));
//        return null;
        
        return new ActionRedirect(getMeetingManagementActionIdHook() + ".do?methodToCall=start&scheduleId="+commSchedule.getId()+"&lineNum="+(getLineToDelete(request)+1)+"&readOnly=" +(!committeeForm.getCommitteeHelper().canModifySchedule()));
    }

    protected abstract String getMeetingManagementActionIdHook();

}
