/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.iacuc.species.rule;

import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

/**
 * This class is implementation of <code>AddProtocolSpeciesRule</code> interface. Impl makes sure necessary rules are satisfied 
 * before object can be used.
 */
public class ProtocolSpeciesRule extends ResearchDocumentRuleBase implements AddProtocolSpeciesRule {
    private static final String NEW_PROTOCOL_SPECIES_PATH = "iacucProtocolSpeciesHelper.newIacucProtocolSpecies";

    /**
     * @see org.kuali.kra.irb.protocol.reference.AddProtocolSpeciesRule#processAddProtocolSpeciesBusinessRules(org.kuali.kra.irb.protocol.reference.AddProtocolSpeciesEvent)
     */
    public boolean processAddProtocolSpeciesBusinessRules(AddProtocolSpeciesEvent addProtocolSpeciesEvent) {
        
        boolean rulePassed = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(NEW_PROTOCOL_SPECIES_PATH);
        IacucProtocolSpecies protocolSpecies = addProtocolSpeciesEvent.getProtocolSpecies();
        
        getDictionaryValidationService().validateBusinessObject(protocolSpecies);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();

        errorMap.removeFromErrorPath(NEW_PROTOCOL_SPECIES_PATH);

        return rulePassed;
    }

}
