/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.irb.actions.grantexemption;

import org.kuali.kra.irb.Protocol;

/**
 * The Protocol Grant Exemption Service is used to grant an
 * exemption to a protocol.
 */
public interface ProtocolGrantExemptionService {

    /**
     * Grant an exemption to a protocol that is
     * submitted to the IRB office.
     * @param protocol
     * @param grantExemptionBean
     * @throws Exception
     */
    public void grantExemption(Protocol protocol, ProtocolGrantExemptionBean grantExemptionBean) throws Exception;
}
