/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.irb.questionnaire;

import java.util.List;

import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.rice.krad.document.Document;


public class SaveProtocolQuestionnaireEvent extends KraDocumentEventBaseExtension {
    private List<AnswerHeader> answerHeaders;

    public SaveProtocolQuestionnaireEvent(Document document, List<AnswerHeader> answerHeaders) {
        super("Saving Protocol Questionnaires (and answers) to document" + getDocumentId(document), Constants.EMPTY_STRING, document);        
        this.answerHeaders = answerHeaders;
    }

    @Override
    public SaveProtocolQuestionnaireRule getRule() {
        return new SaveProtocolQuestionnaireRule();
    }
    
    public List<AnswerHeader> getAnswerHeaders() {
        return answerHeaders;
    }

}
