/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;

import org.kuali.kra.util.watermark.WatermarkConstants;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class WatermarkPositionValuesFinder extends KeyValuesBase{
    
    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(new ConcreteKeyValue("HEADER", WatermarkConstants.WATERMARK_POSITION_HEADER));
        keyValues.add(new ConcreteKeyValue("FOOTER", WatermarkConstants.WATERMARK_POSITION_FOOTER));
        keyValues.add(new ConcreteKeyValue("DIAGONAL", WatermarkConstants.WATERMARK_POSITION_DIAGONAL));
        return keyValues;
    }
}
