/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.meeting;

import org.kuali.kra.common.committee.meeting.MeetingFormBase;

/**
 * 
 * This class is a form for Meeting management,
 */
public class MeetingForm extends MeetingFormBase {
    
    /**
     * Comment for <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = -8524010367028447411L;

    @Override
    protected MeetingHelper getNewMeetingHelperInstanceHook(MeetingFormBase meetingForm) {
        return new MeetingHelper((MeetingForm) meetingForm);
    }
    
// TODO ********************** commented out during IRB backfit ************************    
//    private static final long serialVersionUID = -7825455832928793712L;
//    private MeetingHelper meetingHelper;
//    // textarea needs formKey & document.  
//    private String formKey;
//    private Document document;
//    private boolean readOnly;
//
//    public MeetingForm() {
//        super();
//        initialize();
//    }
//
//    /**
//     * This method initialize all form variables
//     */
//    public void initialize() {
//       setMeetingHelper(new MeetingHelper(this));
//    }
//
//    public MeetingHelper getMeetingHelper() {
//        return meetingHelper;
//    }
//
//
//    public void setMeetingHelper(MeetingHelper meetingHelper) {
//        this.meetingHelper = meetingHelper;
//    }
//
//    public String getFormKey() {
//        return formKey;
//    }
//
//    public void setFormKey(String formKey) {
//        this.formKey = formKey;
//    }
//
//    public Document getDocument() {
//        return document;
//    }
//
//    public void setDocument(Document document) {
//        this.document = document;
//    }
//
//    @Override
//    public void reset(final ActionMapping mapping, final HttpServletRequest request) {
//        super.reset(mapping, request);
//        this.getMeetingHelper().setAbsenteeList("");
//    }
//
//    public boolean isReadOnly() {
//        return readOnly;
//    }
//
//    public void setReadOnly(boolean readOnly) {
//        this.readOnly = readOnly;
//    }
//    
//    /**
//     * 
//     * @see org.kuali.rice.kns.web.struts.form.KualiForm#populate(javax.servlet.http.HttpServletRequest)
//     */
//    @Override
//    public void populate(HttpServletRequest request) {
//        super.populate(request);
//        populateFalseCheckboxes(request);
//    }
//
//    /**
//     * Uses the "checkboxToReset" parameter to find checkboxes which had not been
//     * populated in the request and attempts to populate them
//     * 
//     * @param request the request to populate
//     */
//    @SuppressWarnings("unchecked")
//    private void populateFalseCheckboxes(HttpServletRequest request) {
//        Map<String, String[]> parameterMap = request.getParameterMap();
//        if (parameterMap.get("checkboxToReset") != null) {
//            final String[] checkboxesToReset = request.getParameterValues("checkboxToReset");
//            if(checkboxesToReset != null && checkboxesToReset.length > 0) {
//                for (int i = 0; i < checkboxesToReset.length; i++) {
//                    String propertyName = (String) checkboxesToReset[i];
//                    if ( !StringUtils.isBlank(propertyName) && parameterMap.get(propertyName) == null ) {
//                        populateForProperty(propertyName, KimConstants.KIM_ATTRIBUTE_BOOLEAN_FALSE_STR_VALUE_DISPLAY, parameterMap);
//                    }  
//                    else if ( !StringUtils.isBlank(propertyName) && parameterMap.get(propertyName) != null && parameterMap.get(propertyName).length >= 1 && parameterMap.get(propertyName)[0].equalsIgnoreCase("on") ) {
//                        populateForProperty(propertyName, KimConstants.KIM_ATTRIBUTE_BOOLEAN_TRUE_STR_VALUE_DISPLAY, parameterMap); 
//                    }
//                }
//            }
//        }
//    }

}
