/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.proposaldevelopment.hierarchy.bo;

import java.io.Serializable;


/**
 * This class...
 */
public class HierarchyProposalSummary implements Serializable {
    /**
     * Comment for <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = -4513320772280178341L;

    private String proposalNumber;
    private Boolean synced;
    private String syncableBudgetDocumentNumber;
    private Boolean budgetSynced;

    /**
     * Gets the proposalNumber attribute.
     * 
     * @return Returns the proposalNumber.
     */
    public String getProposalNumber() {
        return proposalNumber;
    }

    /**
     * Sets the proposalNumber attribute value.
     * 
     * @param proposalNumber The proposalNumber to set.
     */
    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    /**
     * Sets the synced attribute value.
     * 
     * @param synced The synced to set.
     */
    public void setSynced(Boolean synced) {
        this.synced = synced;
    }

    /**
     * Gets the synced attribute.
     * 
     * @return Returns the synced.
     */
    public Boolean getSynced() {
        return synced;
    }

    public Boolean getBudgetSynced() {
        return budgetSynced;
    }

    public void setBudgetSynced(Boolean budgetSynced) {
        this.budgetSynced = budgetSynced;
    }

    public String getSyncableBudgetDocumentNumber() {
        return syncableBudgetDocumentNumber;
    }

    public void setSyncableBudgetDocumentNumber(String syncableBudgetDocumentNumber) {
        this.syncableBudgetDocumentNumber = syncableBudgetDocumentNumber;
    }
}
