/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.protocol.actions.reviewcomments;

import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;

/**
 * 
 * This class is validate the new review attachment when 'add' is clicked
 */
public abstract class ProtocolAddReviewAttachmentEventBase<PRA extends ProtocolReviewAttachmentBase> extends KraDocumentEventBaseExtension {
    
    // TODO : technically, this can be refactored to share with ProtocolAddReviewCommentEventBase/rule
    // Since, we are waiting for KRMS, so probably just live with this for now.
    private String propertyName;
    private PRA reviewAttachment;

    /**
     * Constructs a ProtocolAddReviewAttachmentEventBase.
     * 
     * @param document The document to validate
     * @param propertyName The error path property prefix
     * @param reviewAttachment The added Reviewer Attachment
     */
    public ProtocolAddReviewAttachmentEventBase(ProtocolDocumentBase document, String propertyName, PRA reviewAttachment) {
        super("Enter reviewer attachment", "", document);
        this.propertyName = propertyName;
        this.reviewAttachment = reviewAttachment;
    }
    
    public ProtocolDocumentBase getProtocolDocument() {
        return (ProtocolDocumentBase) getDocument();
    }
    
    public String getPropertyName() {
        return propertyName;
    }
    
    public PRA getReviewAttachment() {
        return reviewAttachment;
    }

    @Override
    @SuppressWarnings("unchecked")
    public BusinessRuleInterface getRule() {
        return getNewProtocolAddReviewAttachmentRuleInstancehook();
    }

    protected abstract ProtocolAddReviewAttachmentRule<?> getNewProtocolAddReviewAttachmentRuleInstancehook();


}
