/*
 * Copyright 2005-2013 The Kuali Foundation
 * 
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.opensource.org/licenses/ecl1.php
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;

import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.iacuc.committee.bo.IacucCommittee;
import org.kuali.kra.iacuc.committee.document.CommonCommitteeDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.rice.krad.service.impl.DocumentServiceImpl;
import org.springframework.dao.OptimisticLockingFailureException;

/**
 * 
 * This class is to override documentservice.  It is mainly for CommitteeDocument.
 */
public class KraDocumentServiceImpl extends DocumentServiceImpl {
    private static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory.getLog(KraDocumentServiceImpl.class);

    @Override
    public Document validateAndPersistDocument(Document document, KualiDocumentEvent event) throws ValidationException {
        if (document == null) {
            LOG.error("document passed to validateAndPersist was null");
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("validating and preparing to persist document " + document.getDocumentNumber());
        }

        document.validateBusinessRules(event);
        document.prepareForSave(event);

        // save the document
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("storing document " + document.getDocumentNumber());
            }

            if (document instanceof CommitteeDocument) {
                Committee committee = ((CommitteeDocument) document).getCommittee();
                ((CommitteeDocument) document).setCommitteeList(new ArrayList());
                getDocumentDao().save(document);
                ((CommitteeDocument) document).getCommitteeList().add(committee);
                if (event instanceof RouteDocumentEvent) {
                    getDocumentDao().save(document);
                }
            }
            // TODO remove this else if block after committee backfitting
            else if (document instanceof CommonCommitteeDocument) {
                IacucCommittee committee = ((CommonCommitteeDocument) document).getCommittee();
                ((CommonCommitteeDocument) document).setCommitteeList(new ArrayList());
                getDocumentDao().save(document);
                ((CommonCommitteeDocument) document).getCommitteeList().add(committee);
                if (event instanceof RouteDocumentEvent) {
                    getDocumentDao().save(document);
                }
            }            
            else {
                getDocumentDao().save(document);
            }
        }
        catch (OptimisticLockingFailureException e) {
            LOG.error("exception encountered on store of document " + e.getMessage());
            throw e;
        }

        document.postProcessSave(event);
        return document;
    }

}
