/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.AwardDocumentRule;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardDocumentRuleTest
extends AwardDocumentRule {
    List<AwardFandaRate> awardFandaRateList;
    AwardFandaRate awardFandaRate1;
    AwardFandaRate awardFandaRate2;
    AwardDocumentRule awardDocumentRule;
    AwardReportTerm awardReportTerm;

    @Before
    public void setUp() throws Exception {
        this.awardFandaRateList = new ArrayList<AwardFandaRate>();
        this.awardDocumentRule = new AwardDocumentRule();
        this.awardFandaRate1 = new AwardFandaRate();
        this.awardFandaRate2 = new AwardFandaRate();
        this.awardReportTerm = new AwardReportTerm();
        this.awardFandaRate1.setApplicableFandaRate(new KualiDecimal(5));
        this.awardFandaRate1.setFiscalYear("2008");
        this.awardFandaRate1.setFandaRateTypeCode("5");
        this.awardFandaRate1.setOnCampusFlag("N");
        this.awardFandaRate1.setUnderrecoveryOfIndirectCost(new KualiDecimal(1000));
        this.awardFandaRate1.setStartDate(new Date(new Long("1183316613046")));
        this.awardFandaRate1.setEndDate(new Date(new Long("1214852613046")));
        this.awardFandaRate2.setApplicableFandaRate(new KualiDecimal(5));
        this.awardFandaRate2.setFiscalYear("2008");
        this.awardFandaRate2.setFandaRateTypeCode("5");
        this.awardFandaRate2.setOnCampusFlag("F");
        this.awardFandaRate2.setUnderrecoveryOfIndirectCost(new KualiDecimal(1000));
        this.awardFandaRate2.setStartDate(new Date(new Long("1183316613046")));
        this.awardFandaRate2.setEndDate(new Date(new Long("1214852613046")));
        this.awardFandaRateList.add(this.awardFandaRate1);
        this.awardFandaRateList.add(this.awardFandaRate2);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.awardFandaRateList = null;
        this.awardDocumentRule = null;
        this.awardFandaRate1 = null;
        this.awardFandaRate2 = null;
    }

    @Test
    public final void testEvaluateBusinessRuleForReportCodeField() {
        boolean i = false;
        this.awardReportTerm.setReportClassCode("1");
        this.awardReportTerm.setReportCode("5");
        Assert.assertTrue((boolean)this.awardDocumentRule.isValidReportCode(this.awardReportTerm, this.getReportCodes("1")));
        this.awardReportTerm.setReportClassCode("1");
        this.awardReportTerm.setReportCode("36");
        Assert.assertFalse((boolean)this.awardDocumentRule.isValidReportCode(this.awardReportTerm, this.getReportCodes("1")));
    }

    @Test
    public final void testIsValidFrequencyBase() {
        this.awardReportTerm.setFrequencyBaseCode("5");
        Assert.assertTrue((boolean)this.awardDocumentRule.isValidFrequencyBase(this.awardReportTerm, this.getFrequencyBaseCodes("5")));
        this.awardReportTerm.setFrequencyBaseCode("6");
        Assert.assertFalse((boolean)this.awardDocumentRule.isValidFrequencyBase(this.awardReportTerm, this.getFrequencyBaseCodes("5")));
    }

    protected List<KeyValue> getReportCodes(String reportClassCode) {
        ArrayList<KeyValue> reportCodes = new ArrayList<KeyValue>();
        reportCodes.add((KeyValue)new ConcreteKeyValue("5", "Final"));
        reportCodes.add((KeyValue)new ConcreteKeyValue("39", "SF Something"));
        return reportCodes;
    }

    protected List<KeyValue> getFrequencyCodes(String reportClassCode, String reportCode) {
        ArrayList<KeyValue> frequencyCodes = new ArrayList<KeyValue>();
        frequencyCodes.add((KeyValue)new ConcreteKeyValue("5", "Final"));
        return frequencyCodes;
    }

    protected List<KeyValue> getFrequencyBaseCodes(String frequencyCode) {
        ArrayList<KeyValue> frequencyBaseCodes = new ArrayList<KeyValue>();
        frequencyBaseCodes.add((KeyValue)new ConcreteKeyValue("5", "Final"));
        return frequencyBaseCodes;
    }
}

