/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public abstract class AwardRuleTestBase
extends KcUnitTestBase {
    protected DocumentService documentService = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        GlobalVariables.setMessageMap(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        this.documentService = null;
        super.tearDown();
    }

    protected AwardDocument getNewAwardDocument() throws WorkflowException {
        return (AwardDocument)this.documentService.getNewDocument("AwardDocument");
    }

    protected void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        AwardRuleTestBase.assertNotNull((Object)errors);
        AwardRuleTestBase.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        AwardRuleTestBase.assertNotNull((Object)message);
        AwardRuleTestBase.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }
}

