/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.sql.Date;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardVersioningTest
extends KcUnitTestBase {
    private static final Log LOG = LogFactory.getLog(AwardVersioningTest.class);
    private static final double COST_SHARE_COMMIT_AMT = 1000.0;
    private static final String COST_SHARE_DEST1 = "576434";
    private static final String COST_SHARE_DEST2 = "777777";
    private static final String COST_SHARE_SOURCE = "7568657";
    private static final String FISCAL_YEAR = "2009";
    private static final String VENDOR_A = "VendorA";
    private static final String MODEL_A = "ModelA";
    private static final String ITEM_A = "ItemA";
    private static final String ITEM_B = "ItemB";
    private static final double AMOUNT = 1000.0;
    private static final String AWARD_TITLE = "Award Title";
    private static final String GOOGLE_SPONSOR_CODE = "005979";
    private static final String SPONSOR_AWARD_NUMBER = "1R01CA123456";
    private static final String DOCUMENT_DESCRIPTION = "Award Versioning Test Document";
    private BusinessObjectService bos;
    private DocumentService documentService;
    private VersioningService versioningService;
    private List<AwardDocument> savedDocuments;
    private List<Award> awards;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.savedDocuments = new ArrayList<AwardDocument>();
        this.awards = new ArrayList<Award>();
        this.locateServices();
        this.initializeAward();
        AwardDocument originalDocument = this.initializeNewDocument(this.awards.get(0));
        this.saveDocument(originalDocument);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testVersioningAward_Level1() throws VersionException, WorkflowException {
        Award awardVersion2 = this.versionAward(this.savedDocuments.get(0));
        this.addSomeApprovedEquipmentAndVerifyBaseline(awardVersion2);
        this.addSomeAwardCommentsAndVerifyBaseline(awardVersion2);
        this.addSomeAwardCostSharesAndVerifyBaseline(awardVersion2);
        this.addSomeAwardFandaRatesAndVerifyBaseline(awardVersion2);
        this.addSomeAwardReportTermsAndVerifyBaseline(awardVersion2);
        this.addSomeAwardSponsorTermsAndVerifyBaseline(awardVersion2);
        this.addSomeAwardSubawardsAndVerifyBaseline(awardVersion2);
        this.addSomeAwardSpecialReviewsAndVerifyBaseline(awardVersion2);
        Award awardVersion3 = (Award)this.versioningService.createNewVersion((SequenceOwner)awardVersion2);
        AwardVersioningTest.assertEquals((long)2L, (long)awardVersion2.getApprovedEquipmentItemCount());
        AwardVersioningTest.assertEquals((long)2L, (long)awardVersion3.getApprovedEquipmentItemCount());
        AwardDocument document = (AwardDocument)this.documentService.saveDocument((Document)this.initializeNewDocument(awardVersion3));
        awardVersion3 = document.getAward();
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getApprovedEquipmentItems(), awardVersion3.getApprovedEquipmentItems());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getAwardComments(), awardVersion3.getAwardComments());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getAwardCostShares(), awardVersion3.getAwardCostShares());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getAwardFandaRate(), awardVersion3.getAwardFandaRate());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getAwardReportTermItems(), awardVersion3.getAwardReportTermItems());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getAwardSponsorTerms(), awardVersion3.getAwardSponsorTerms());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getAwardApprovedSubawards(), awardVersion3.getAwardApprovedSubawards());
        this.verifySequenceAssociatesAfterVersioning(awardVersion2.getSpecialReviews(), awardVersion3.getSpecialReviews());
    }

    private void addSomeApprovedEquipmentAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(new AwardApprovedEquipment(VENDOR_A, MODEL_A, ITEM_A, 1000.0));
        awardVersion2.add(new AwardApprovedEquipment(VENDOR_A, MODEL_A, ITEM_B, 1000.0));
        this.saveAndVerifySequenceAssociateValues(awardVersion2, awardVersion2.getApprovedEquipmentItems());
    }

    private void addSomeAwardCommentsAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createComment("Comment 1"));
        awardVersion2.add(this.createComment("Comment 2"));
        awardVersion2.add(this.createComment("Comment 3"));
        this.saveAndVerifySequenceAssociateValues(awardVersion2, awardVersion2.getAwardComments());
    }

    private void addSomeAwardCostSharesAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createCostShare(0.75, COST_SHARE_DEST1));
        awardVersion2.add(this.createCostShare(0.25, COST_SHARE_DEST2));
        this.saveAndVerifySequenceAssociateValues(awardVersion2, awardVersion2.getAwardCostShares());
    }

    private void addSomeAwardFandaRatesAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createAwardFandaRate("N"));
        awardVersion2.add(this.createAwardFandaRate("F"));
        this.saveAndVerifySequenceAssociateValues(awardVersion2, awardVersion2.getAwardFandaRate());
    }

    private void addSomeAwardReportTermsAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createAwardReportTerm("2", "39", "14", "2"));
        awardVersion2.add(this.createAwardReportTerm("1", "5", "14", "2"));
    }

    private void addSomeAwardSponsorTermsAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createAwardSponsorTerm());
    }

    private void addSomeAwardSubawardsAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createApprovedSubaward("Org A"));
        awardVersion2.add(this.createApprovedSubaward("Org B"));
    }

    private void addSomeAwardSpecialReviewsAndVerifyBaseline(Award awardVersion2) {
        awardVersion2.add(this.createSpecialReview(1, "2", "1"));
        awardVersion2.add(this.createSpecialReview(2, "2", "2"));
    }

    private AwardApprovedSubaward createApprovedSubaward(String organizationName) {
        AwardApprovedSubaward subaward = new AwardApprovedSubaward();
        subaward.setAmount(new KualiDecimal(100.0));
        subaward.setOrganizationName(organizationName);
        return subaward;
    }

    private AwardReportTerm createAwardReportTerm(String reportClassCode, String reportCode, String frequencyCode, String frequencyBaseCode) {
        AwardReportTerm term = new AwardReportTerm();
        term.setReportClassCode(reportClassCode);
        term.setReportCode(reportCode);
        term.setFrequencyBaseCode(frequencyBaseCode);
        term.setFrequencyCode(frequencyCode);
        term.setDueDate(new Date(10000332L));
        term.setOspDistributionCode("1");
        return term;
    }

    private AwardSponsorTerm createAwardSponsorTerm() {
        AwardSponsorTerm term = new AwardSponsorTerm();
        term.setSponsorTermId(null);
        return term;
    }

    private AwardComment createComment(String commentText) {
        AwardComment comment = new AwardComment();
        comment.setComments(commentText);
        comment.setChecklistPrintFlag(Boolean.TRUE);
        comment.setCommentTypeCode("1");
        return comment;
    }

    private AwardCostShare createCostShare(double costSharePct, String destination) {
        AwardCostShare costShare = new AwardCostShare();
        costShare.setCostSharePercentage(new KualiDecimal(costSharePct));
        costShare.setCostShareMet(costShare.getCostSharePercentage());
        costShare.setCostShareTypeCode(Integer.valueOf(1));
        costShare.setProjectPeriod(FISCAL_YEAR);
        costShare.setSource(COST_SHARE_SOURCE);
        costShare.setDestination(destination);
        costShare.setCommitmentAmount(new KualiDecimal(1000.0));
        return costShare;
    }

    private AwardFandaRate createAwardFandaRate(String onOffCampusFlag) {
        AwardFandaRate rate = new AwardFandaRate();
        rate.setApplicableFandaRate(new KualiDecimal(5.0));
        rate.setFandaRateTypeCode("1");
        rate.setFiscalYear("2008");
        rate.setStartDate(new Date(new GregorianCalendar(2007, 6, 1).getTimeInMillis()));
        rate.setStartDate(new Date(new GregorianCalendar(2008, 5, 30).getTimeInMillis()));
        rate.setOnCampusFlag(onOffCampusFlag);
        return rate;
    }

    private AwardSpecialReview createSpecialReview(Integer specialReviewNo, String specialReviewCode, String approvalTypeCode) {
        AwardSpecialReview review = new AwardSpecialReview();
        review.setSpecialReviewNumber(specialReviewNo);
        review.setSpecialReviewTypeCode(specialReviewCode);
        review.setApprovalTypeCode(approvalTypeCode);
        return review;
    }

    private void initializeAward() {
        Award awardVersion1 = new Award();
        awardVersion1.setAwardTypeCode(Integer.valueOf(1));
        awardVersion1.setTitle(AWARD_TITLE);
        awardVersion1.setActivityTypeCode("1");
        awardVersion1.setAwardTransactionTypeCode(Integer.valueOf(1));
        awardVersion1.setUnitNumber("IN-CARD");
        awardVersion1.setPrimeSponsorCode(GOOGLE_SPONSOR_CODE);
        awardVersion1.setSponsorCode(GOOGLE_SPONSOR_CODE);
        awardVersion1.setStatusCode(Integer.valueOf(1));
        awardVersion1.setModificationNumber("1");
        awardVersion1.setSponsorAwardNumber(SPONSOR_AWARD_NUMBER);
        Date date = new Date(System.currentTimeMillis());
        awardVersion1.setAwardEffectiveDate(date);
        awardVersion1.setAwardExecutionDate(date);
        awardVersion1.setBeginDate(date);
        awardVersion1.setProjectEndDate(date);
        this.awards.add(awardVersion1);
    }

    private AwardDocument initializeNewDocument(Award award) throws WorkflowException {
        AwardDocument document = (AwardDocument)this.documentService.getNewDocument(AwardDocument.class);
        document.getDocumentHeader().setDocumentDescription(DOCUMENT_DESCRIPTION);
        document.setAward(award);
        return document;
    }

    private void locateServices() {
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.versioningService = (VersioningService)KraServiceLocator.getService(VersioningService.class);
    }

    private void saveAndVerifySequenceAssociateValues(Award award, List<? extends SequenceAssociate> items) {
        this.bos.save((PersistableBusinessObject)award);
        HashMap<String, Long> keys = new HashMap<String, Long>();
        keys.put("awardId", award.getAwardId());
        award = (Award)this.bos.findByPrimaryKey(Award.class, keys);
        for (SequenceAssociate sequenceAssociate : items) {
            AwardVersioningTest.assertEquals((Object)award.getSequenceNumber(), (Object)sequenceAssociate.getSequenceNumber());
            AwardVersioningTest.assertEquals((Object)award.getAwardId(), (Object)((Award)sequenceAssociate.getSequenceOwner()).getAwardId());
        }
    }

    private AwardDocument saveDocument(AwardDocument document) throws WorkflowException {
        try {
            document = (AwardDocument)this.documentService.saveDocument((Document)document);
            this.savedDocuments.add(document);
            return document;
        }
        catch (WorkflowException e) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            if (errorMap.getErrorCount() > 0) {
                for (String errorProperty : errorMap.getPropertiesWithErrors()) {
                    LOG.error((Object)("-------\nProperty in error " + errorProperty));
                    for (Object error : errorMap.getErrorMessagesForProperty(errorProperty)) {
                        LOG.error(error);
                    }
                }
            }
            throw e;
        }
    }

    private void verifySequenceAssociatesAfterVersioning(List<? extends SequenceAssociate> sequenceAssociatesBeforeVersioning, List<? extends SequenceAssociate> sequenceAssociatesAfterVersioning) {
        AwardVersioningTest.assertEquals((long)sequenceAssociatesBeforeVersioning.size(), (long)sequenceAssociatesAfterVersioning.size());
        for (int index = 0; index < sequenceAssociatesBeforeVersioning.size(); ++index) {
            SequenceAssociate associateBeforeVersioning = sequenceAssociatesBeforeVersioning.get(index);
            SequenceAssociate associateAfterVersioning = sequenceAssociatesAfterVersioning.get(index);
            AwardVersioningTest.assertEquals((long)(associateBeforeVersioning.getSequenceNumber() + 1), (long)associateAfterVersioning.getSequenceNumber().intValue());
        }
    }

    private Award versionAward(AwardDocument oldVersionDocument) throws VersionException, WorkflowException {
        Award oldVersion = oldVersionDocument.getAward();
        Award newVersion = (Award)this.versioningService.createNewVersion((SequenceOwner)oldVersion);
        AwardVersioningTest.assertEquals((long)(oldVersion.getSequenceNumber() + 1), (long)newVersion.getSequenceNumber().intValue());
        AwardVersioningTest.assertNull((Object)newVersion.getAwardId());
        AwardDocument newDocument = this.initializeNewDocument(newVersion);
        newDocument = this.saveDocument(newDocument);
        AwardDocument fetchedOldVersionDocument = (AwardDocument)this.documentService.getByDocumentHeaderId(oldVersionDocument.getDocumentNumber());
        Award fetchedOldVersionAward = fetchedOldVersionDocument.getAward();
        AwardVersioningTest.assertEquals((Object)oldVersion.getAwardId(), (Object)fetchedOldVersionAward.getAwardId());
        AwardVersioningTest.assertEquals((Object)oldVersion.getSequenceNumber(), (Object)fetchedOldVersionAward.getSequenceNumber());
        AwardDocument fetchedNewVersionDocument = (AwardDocument)this.documentService.getByDocumentHeaderId(newDocument.getDocumentNumber());
        Award fetchedNewVersion = fetchedNewVersionDocument.getAward();
        AwardVersioningTest.assertNotSame((Object)oldVersion.getAwardId(), (Object)fetchedNewVersion.getAwardId());
        AwardVersioningTest.assertEquals((long)(oldVersion.getSequenceNumber() + 1), (long)fetchedNewVersion.getSequenceNumber().intValue());
        return fetchedNewVersion;
    }
}

