/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.util.ArrayList;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyServiceImpl;
import org.kuali.kra.award.awardhierarchy.MissingHierarchyException;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class AwardHierarchyBeanTest {
    private static final String ROOT_AWARD_NUMBER = "100001-00001";
    private static final String UNKNOWN_TARGET_NODE_AWARD_NUMBER = "123456-78901";
    private AwardHierarchyBean bean;
    private AwardHierarchyServiceImpl service;
    private Award rootAward;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.service = new AwardHierarchyServiceImpl();
        this.service.setBusinessObjectService(this.getMockBusinessObjectService());
        this.service.setDocumentService(this.getMockDocumentService());
        this.rootAward = new Award();
        this.rootAward.setAwardNumber(ROOT_AWARD_NUMBER);
        this.createAwardHierarchyBean();
    }

    @After
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testSaveHierarchyChanges_NoError() {
        Assert.assertTrue((boolean)this.bean.saveHierarchyChanges());
    }

    @Test(expected=MissingHierarchyException.class)
    public void testCreatingNewChildAwardBasedOnAnotherAwardInHierarchy_BadInput() {
        String targetAwardNumber = this.bean.getRootNode().getAwardNumber();
        String awardNumberOfAwardToBeUsedAsTemplate = UNKNOWN_TARGET_NODE_AWARD_NUMBER;
        this.bean.createNewChildAwardBasedOnAnotherAwardInHierarchy(targetAwardNumber, awardNumberOfAwardToBeUsedAsTemplate);
    }

    @Test
    public void testGettingNodeForCurrentAward() {
        Assert.assertEquals((Object)this.rootAward.getAwardNumber(), (Object)this.bean.getCurrentAwardHierarchyNode().getAwardNumber());
    }

    private void createAwardHierarchyBean() {
        this.bean = new AwardHierarchyBeanForUnitTest(null, (AwardHierarchyService)this.service);
        this.bean.getRootNodes().put(this.rootAward.getAwardNumber(), AwardHierarchy.createRootNode((Award)this.rootAward));
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Map fieldValues = ServiceHelper.getInstance().buildCriteriaMap("documentDescription", (Object)"*****PLACEHOLDER*****");
                ((BusinessObjectService)this.one(service)).findMatching(DocumentHeader.class, fieldValues);
                this.will(1.returnValue(new ArrayList()));
                Map primaryKeys = ServiceHelper.getInstance().buildCriteriaMap(new String[]{"awardNumber", "active"}, new Object[]{AwardHierarchyBeanTest.ROOT_AWARD_NUMBER, Boolean.TRUE});
                ((BusinessObjectService)this.allowing(service)).findByPrimaryKey(AwardHierarchy.class, primaryKeys);
                this.will(1.returnValue(null));
            }
        });
        return service;
    }

    private DocumentService getMockDocumentService() throws WorkflowException {
        final DocumentService service = (DocumentService)this.context.mock(DocumentService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DocumentService)this.one(service)).getNewDocument(AwardDocument.class);
                this.will(2.returnValue(null));
            }
        });
        return service;
    }

    private class AwardHierarchyBeanForUnitTest
    extends AwardHierarchyBean {
        Award award;

        AwardHierarchyBeanForUnitTest(AwardForm awardForm, AwardHierarchyService service) {
            super(awardForm, service);
        }

        Award getAward() {
            return this.award != null ? this.award : AwardHierarchyBeanTest.this.rootAward;
        }
    }
}

