/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyServiceImpl;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardServiceImpl;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class AwardHierarchyServiceImplTest
extends KcUnitTestBase {
    private static final int NUMBER_OF_CHILDREN_A = 20;
    private static final int NUMBER_OF_GRANDCHILDREN_A = 10;
    private static final int NUMBER_OF_CHILDREN_B = 10;
    private static final int NUMBER_OF_GRANDCHILDREN_B = 5;
    private static final long BASE_AWARD_NUMBER = 100001L;
    private static final int BASE_HIERARCHY_SEQUENCE = 1;
    private static final String DUMMY_AWARD_NUMBER = "999999-99999";
    private static final String AWARD_NUMBER_PATTERN = "%06d-%05d";
    private static final String DEFAULT_ROOT_AWARD_NUMBER = "100001-00001";
    private static final String NEXT_AWARD_NUMBER_FOR_NEW_HIERARCHY = "100002-00001";
    private AwardHierarchyServiceImpl service;
    private List<Award> awardList = new ArrayList<Award>();
    private AwardDocument placeholderDocument;
    private AwardHierarchy rootNodeA;
    private AwardHierarchy rootNodeB;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new AwardHierarchyServiceImpl();
        this.service.setAwardNumberService(this.getMockAwardNumberService());
        this.service.setBusinessObjectService(this.getBusinessObjectService());
        this.service.setDocumentService(this.getDocumentService());
        this.service.setVersioningService((VersioningService)KraServiceLocator.getService(VersioningService.class));
        this.service.setVersionHistoryService((VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class));
        this.service.setAwardService((AwardService)new AwardServiceMock());
        this.awardList = new ArrayList<Award>();
        this.rootNodeA = this.createFullAwardHierarchy(100001L, 20, 10);
        this.addAwards(this.rootNodeA);
        this.rootNodeB = this.createFullAwardHierarchy(200001L, 10, 5);
        this.addAwards(this.rootNodeB);
        this.service.persistAwardHierarchy(this.rootNodeA, true);
        this.service.persistAwardHierarchy(this.rootNodeB, true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testFindingNode_NotPersisted() {
        AwardHierarchy node = this.service.loadAwardHierarchy(DUMMY_AWARD_NUMBER);
        Assert.assertNull((Object)node);
    }

    @Test
    public void testCopyingAwardAsNewHierarchy() {
        AwardHierarchy newRootNode = this.service.copyAwardAsNewHierarchy((AwardHierarchy)this.rootNodeA.getChildren().get(1));
        Assert.assertFalse((boolean)newRootNode.hasChildren());
        newRootNode.setVersionHistoryService(this.getVersionHistoryService());
        Award newAward = newRootNode.getAward();
        String awardNumber = newAward.getAwardNumber();
        Assert.assertEquals((Object)"00001", (Object)awardNumber.substring(awardNumber.indexOf("-") + 1));
        Assert.assertEquals((long)1L, (long)newAward.getSequenceNumber().intValue());
    }

    @Test
    public void testCopyingAwardAsChildOfAnAwardInAnotherHierarchy() {
        AwardHierarchy sourceNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        AwardHierarchy targetParentNode = (AwardHierarchy)this.rootNodeB.getChildren().get(2);
        int originalNumberOfChildrenOnTargetNode = targetParentNode.getChildren().size();
        AwardHierarchy newNode = this.service.copyAwardAsChildOfAnAwardInAnotherHierarchy(sourceNode, targetParentNode);
        Assert.assertEquals((Object)targetParentNode, (Object)newNode.getParent());
        Assert.assertEquals((long)(originalNumberOfChildrenOnTargetNode + 1), (long)targetParentNode.childCount());
    }

    @Test
    public void testCopyingAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy() {
        AwardHierarchy sourceNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        AwardHierarchy targetParentNode = (AwardHierarchy)this.rootNodeB.getChildren().get(2);
        int originalNumberOfChildrenOnTargetNode = targetParentNode.getChildren().size();
        AwardHierarchy newNode = this.service.copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(sourceNode, targetParentNode);
        Assert.assertEquals((Object)targetParentNode, (Object)newNode.getParent());
        Assert.assertTrue((boolean)newNode.hasChildren());
        Assert.assertEquals((long)sourceNode.childCount(), (long)newNode.childCount());
        Assert.assertEquals((long)(originalNumberOfChildrenOnTargetNode + 1), (long)newNode.getParent().childCount());
        Assert.assertEquals((Object)newNode.getAward().getTitle(), (Object)sourceNode.getAward().getTitle());
    }

    @Test
    public void testCopyingAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy() {
        AwardHierarchy sourceNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        AwardHierarchy targetParentNode = (AwardHierarchy)((AwardHierarchy)this.rootNodeA.getChildren().get(2)).getChildren().get(1);
        int originalNumberOfChildrenOnTargetNode = targetParentNode.childCount();
        AwardHierarchy newBranchNode = this.service.copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(sourceNode, targetParentNode);
        Assert.assertEquals((Object)targetParentNode, (Object)newBranchNode.getParent());
        Assert.assertTrue((boolean)newBranchNode.hasChildren());
        Assert.assertEquals((long)(originalNumberOfChildrenOnTargetNode + 1), (long)newBranchNode.getParent().childCount());
        Assert.assertEquals((long)sourceNode.childCount(), (long)newBranchNode.childCount());
        Assert.assertEquals((Object)newBranchNode.getAward().getTitle(), (Object)sourceNode.getAward().getTitle());
        for (int i = 0; i < sourceNode.childCount(); ++i) {
            Assert.assertEquals((Object)((AwardHierarchy)sourceNode.getChildren().get(i)).getAward().getTitle(), (Object)((AwardHierarchy)newBranchNode.getChildren().get(i)).getAward().getTitle());
        }
    }

    @Test
    public void testCopyingAwardAndDescendantsAsNewHierarchy() {
        AwardHierarchy targetNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        AwardHierarchy newNode = this.service.copyAwardAndAllDescendantsAsNewHierarchy(targetNode);
        Assert.assertTrue((boolean)newNode.isRootNode());
        Assert.assertTrue((boolean)newNode.hasChildren());
        Assert.assertEquals((long)targetNode.getChildren().size(), (long)newNode.getChildren().size());
        Assert.assertEquals((Object)targetNode.getAward().getTitle(), (Object)newNode.getAward().getTitle());
        for (int i = 0; i < targetNode.getChildren().size(); ++i) {
            Assert.assertEquals((Object)((AwardHierarchy)targetNode.getChildren().get(i)).getAward().getTitle(), (Object)((AwardHierarchy)newNode.getChildren().get(i)).getAward().getTitle());
        }
    }

    @Test
    public void testCopyingAwardAsChildOfAnAwardInCurrentHierarchy() {
        AwardHierarchy sourceNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        AwardHierarchy targetParentNode = (AwardHierarchy)this.rootNodeA.getChildren().get(2);
        int originalNumberOfChildrenOnTargetNode = targetParentNode.getChildren().size();
        AwardHierarchy newNode = this.service.copyAwardAsChildOfAnAwardInCurrentHierarchy(sourceNode, targetParentNode);
        Assert.assertEquals((Object)targetParentNode, (Object)newNode.getParent());
        Assert.assertEquals((long)(originalNumberOfChildrenOnTargetNode + 1), (long)targetParentNode.childCount());
    }

    @Test
    public void testCreatingBasicHierarchy() {
        AwardHierarchy rootNodeA = this.createAwardHierarchy(DEFAULT_ROOT_AWARD_NUMBER);
        rootNodeA.setVersionHistoryService(this.getVersionHistoryService());
        AwardHierarchyServiceImplTest.assertNotNull((Object)rootNodeA);
        String awardNumber = rootNodeA.getAwardNumber();
        AwardHierarchyServiceImplTest.assertEquals((Object)awardNumber, (Object)rootNodeA.getAwardNumber());
        AwardHierarchyServiceImplTest.assertEquals((Object)awardNumber, (Object)rootNodeA.getRootAwardNumber());
        AwardHierarchyServiceImplTest.assertEquals((Object)"000000-00000", (Object)rootNodeA.getParentAwardNumber());
    }

    @Test
    public void testCreatingFullHierarchy() {
        AwardHierarchy rootNode = this.service.loadFullHierarchyFromAnyNode(this.generateAwardNumber(100001L, 1));
        AwardHierarchyServiceImplTest.assertNotNull((Object)rootNode);
        AwardHierarchyServiceImplTest.assertEquals((Object)this.rootNodeA, (Object)rootNode);
        AwardHierarchyServiceImplTest.assertTrue((boolean)this.rootNodeA.hasChildren());
        AwardHierarchyServiceImplTest.assertEquals((long)20L, (long)this.rootNodeA.getChildren().size());
        int hierarchySequenceNumber = 2;
        for (AwardHierarchy child : this.rootNodeA.getChildren()) {
            AwardHierarchyServiceImplTest.assertEquals((Object)this.rootNodeA.getAwardNumber(), (Object)child.getRootAwardNumber());
            AwardHierarchyServiceImplTest.assertEquals((Object)this.rootNodeA.getAwardNumber(), (Object)child.getParentAwardNumber());
            AwardHierarchyServiceImplTest.assertEquals((Object)this.generateAwardNumber(100001L, hierarchySequenceNumber++), (Object)child.getAwardNumber());
            for (AwardHierarchy grandChild : child.getChildren()) {
                AwardHierarchyServiceImplTest.assertEquals((Object)this.rootNodeA.getAwardNumber(), (Object)grandChild.getRootAwardNumber());
                AwardHierarchyServiceImplTest.assertEquals((Object)child.getAwardNumber(), (Object)grandChild.getParentAwardNumber());
                AwardHierarchyServiceImplTest.assertEquals((Object)this.generateAwardNumber(100001L, hierarchySequenceNumber++), (Object)grandChild.getAwardNumber());
            }
        }
    }

    @Test
    public void testCreatingANewChildAward() {
        AwardHierarchy targetNode = (AwardHierarchy)this.rootNodeA.getChildren().get(0);
        String expectedAwardNumber = targetNode.generateNextAwardNumberInSequence();
        AwardHierarchy newNode = this.service.createNewChildAward(targetNode);
        Assert.assertEquals((Object)targetNode, (Object)newNode.getParent());
        Assert.assertEquals((Object)targetNode.getRoot(), (Object)newNode.getRoot());
        Assert.assertEquals((Object)expectedAwardNumber, (Object)newNode.getAwardNumber());
        Assert.assertNotNull((Object)newNode.getAward());
    }

    @Test
    public void testCreatingNewChildAwardBasedOnAnotherAwardInHierarchy() {
        AwardHierarchy targetNode = (AwardHierarchy)((AwardHierarchy)this.rootNodeA.getChildren().get(2)).getChildren().get(1);
        AwardHierarchy copyNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        AwardHierarchy newChildNode = this.service.createNewAwardBasedOnAnotherAwardInHierarchy(copyNode, targetNode);
        Assert.assertEquals((Object)targetNode.getAwardNumber(), (Object)newChildNode.getParent().getAwardNumber());
        Assert.assertEquals((Object)this.rootNodeA.getAwardNumber(), (Object)newChildNode.getRoot().getAwardNumber());
        Assert.assertEquals((Object)copyNode.getAward().getTitle(), (Object)newChildNode.getAward().getTitle());
        Assert.assertEquals((Object)copyNode.getOriginatingAwardNumber(), (Object)newChildNode.getOriginatingAwardNumber());
    }

    @Test
    public void testCreatingNewAwardBasedOnParent() {
        AwardHierarchy targetNode = (AwardHierarchy)this.rootNodeA.getChildren().get(1);
        String expectedAwardNumber = targetNode.generateNextAwardNumberInSequence();
        AwardHierarchy newNode = this.service.createNewAwardBasedOnParent(targetNode);
        Assert.assertEquals((Object)targetNode, (Object)newNode.getParent());
        Assert.assertEquals((Object)targetNode.getRoot(), (Object)newNode.getRoot());
        Assert.assertEquals((Object)expectedAwardNumber, (Object)newNode.getAwardNumber());
        Award newAward = newNode.getAward();
        Assert.assertEquals((long)1L, (long)newAward.getSequenceNumber().intValue());
        Assert.assertEquals((Object)targetNode.getAward().getTitle(), (Object)newAward.getTitle());
    }

    @Test
    public void testCreatingRootNode_NullAwardNumber() {
        AwardHierarchyServiceImplTest.assertNull((Object)this.service.loadAwardHierarchy(null));
    }

    @Test
    @Ignore
    public void testCreateNewChildAward() {
        AwardHierarchy root = this.createFullAwardHierarchy(100001L, 20, 10);
        AwardHierarchy childNode = (AwardHierarchy)root.getChildren().get(1);
        int numGrandChildren = childNode.getChildren().size();
        AwardHierarchy newGrandChild = this.service.createNewChildAward(childNode);
        Assert.assertEquals((long)(numGrandChildren + 1), (long)childNode.getChildren().size());
        Assert.assertNotNull((Object)newGrandChild.getAward());
    }

    @Test
    public void testGettingHierarchyAsMap_UsingVarunification() {
        Map refMap = this.rootNodeA.getMapOfNodesInHierarchy();
        ArrayList awardNumbers = new ArrayList();
        Map nodeMap = this.service.getAwardHierarchy(this.rootNodeA.getAwardNumber(), awardNumbers);
        Assert.assertEquals((long)awardNumbers.size(), (long)nodeMap.size());
        for (String awardNumber : nodeMap.keySet()) {
            Assert.assertEquals(refMap.get(awardNumber), nodeMap.get(awardNumber));
        }
    }

    private void addAwards(AwardHierarchy rootNode) throws Exception {
        List nodes = rootNode.getFlattenedListOfNodesInHierarchy();
        for (AwardHierarchy node : nodes) {
            Award award = this.createAward(node.getAwardNumber());
            if (this.placeholderDocument != null) {
                this.placeholderDocument.getAwardList().add(award);
                award.setAwardDocument(this.placeholderDocument);
                this.getDocumentService().saveDocument((Document)this.placeholderDocument);
            } else {
                this.awardList.add(award);
            }
            node.setAward(award);
            this.getBusinessObjectService().save((PersistableBusinessObject)node);
        }
    }

    private AwardHierarchy createAwardHierarchy(String awardNumber) {
        Award award = this.createAward(awardNumber);
        AwardHierarchy node = this.service.createBasicHierarchy(award.getAwardNumber());
        node.setVersionHistoryService(this.getVersionHistoryService());
        return node;
    }

    private AwardHierarchy createFullAwardHierarchy(Long baseAwardNumber, int numberOfChildNodes, int numberOfGrandChildren) {
        int i;
        AwardHierarchy rootNodeA = this.createRootHierarchyNode(baseAwardNumber);
        ArrayList<AwardHierarchy> childNodes = new ArrayList<AwardHierarchy>();
        int sequenceNo = i + 2;
        for (i = 0; i < numberOfChildNodes; ++i) {
            AwardHierarchy childBranchNode = new AwardHierarchy(rootNodeA, rootNodeA, this.generateAwardNumber(baseAwardNumber, sequenceNo++), DUMMY_AWARD_NUMBER);
            childBranchNode.setBusinessObjectService(this.getBusinessObjectService());
            childBranchNode.setVersionHistoryService(this.getVersionHistoryService());
            childNodes.add(childBranchNode);
            ArrayList<AwardHierarchy> grandchildNodes = new ArrayList<AwardHierarchy>();
            for (int j = 0; j < numberOfGrandChildren; ++j) {
                AwardHierarchy grandChildNode = new AwardHierarchy(rootNodeA, childBranchNode, this.generateAwardNumber(baseAwardNumber, sequenceNo++), DUMMY_AWARD_NUMBER);
                childBranchNode.setBusinessObjectService(this.getBusinessObjectService());
                grandChildNode.setVersionHistoryService(this.getVersionHistoryService());
                grandchildNodes.add(grandChildNode);
            }
            childBranchNode.setChildren(grandchildNodes);
        }
        rootNodeA.setChildren(childNodes);
        return rootNodeA;
    }

    private AwardHierarchy createRootHierarchyNode(Long baseAwardNumber) {
        Award rootAward = new Award();
        rootAward.setAwardNumber(this.generateAwardNumber(baseAwardNumber, 1));
        AwardHierarchy rootNode = AwardHierarchy.createRootNode((Award)rootAward);
        rootNode.setVersionHistoryService(this.getVersionHistoryService());
        rootNode.setBusinessObjectService(this.getBusinessObjectService());
        return rootNode;
    }

    private Award createAward(String awardNumber) {
        Award award = new Award();
        award.setAwardNumber(awardNumber);
        award.setSequenceNumber(Integer.valueOf(1));
        award.setAwardId(null);
        award.setProjectEndDate(new Date(System.currentTimeMillis()));
        award.setSponsorCode("000162");
        award.setStatusCode(Integer.valueOf(1));
        award.setActivityTypeCode("1");
        award.setAwardTypeCode(Integer.valueOf(1));
        award.setTitle("Sample Award: " + awardNumber);
        return award;
    }

    private String generateAwardNumber(long baseAwardNumber, int hierarchySequenceNumber) {
        return String.format(AWARD_NUMBER_PATTERN, baseAwardNumber, hierarchySequenceNumber);
    }

    private AwardNumberService getMockAwardNumberService() {
        final AwardNumberService service = (AwardNumberService)this.context.mock(AwardNumberService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((AwardNumberService)this.one(service)).getNextAwardNumber();
                this.will(1.returnValue((Object)AwardHierarchyServiceImplTest.NEXT_AWARD_NUMBER_FOR_NEW_HIERARCHY));
            }
        });
        return service;
    }

    private VersionHistoryService getVersionHistoryService() {
        return (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
    }

    private class AwardServiceMock
    extends AwardServiceImpl {
        private AwardServiceMock() {
        }

        public void updateAwardSequenceStatus(Award award, VersionStatus status) {
        }
    }
}

