/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.service.impl.VersionHistoryServiceImpl;
import org.kuali.kra.service.impl.adapters.BusinessObjectServiceAdapter;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardHierarchyTest {
    private static final String AWARD_NUMBER_PATTERN = "%06d-%05d";
    private static final long BASE_AWARD_NUMBER = 100001L;
    private static final int BASE_HIERACHY_SEQUENCE = 1;
    private static final int NUMBER_OF_CHILDREN = 10;
    private static final int NUMBER_OF_GRANDCHILDREN = 5;

    @Test
    public void testCreatingRootNode() {
        Award award = this.createRootAward();
        AwardHierarchy root = AwardHierarchy.createRootNode((Award)award);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)this.generateAwardNumber(100001L, 1), (Object)root.getAwardNumber());
        Assert.assertEquals((Object)root.getAwardNumber(), (Object)root.getRootAwardNumber());
        Assert.assertEquals((Object)"000000-00000", (Object)root.getParentAwardNumber());
    }

    @Test
    public void testFindingRootNode() {
        AwardHierarchy rootNode;
        AwardHierarchy testNode = rootNode = this.createFullHierarchy();
        Assert.assertEquals((Object)rootNode, (Object)testNode.findRootNode());
        testNode = (AwardHierarchy)((AwardHierarchy)rootNode.getChildren().get(1)).getChildren().get(2);
        Assert.assertEquals((Object)rootNode, (Object)testNode.findRootNode());
    }

    @Test
    public void testFindingNodeInHierarchy() {
        AwardHierarchy rootNode;
        AwardHierarchy startNode = rootNode = this.createFullHierarchy();
        AwardHierarchy testNode = (AwardHierarchy)((AwardHierarchy)startNode.getChildren().get(1)).getChildren().get(2);
        Assert.assertEquals((Object)testNode, (Object)startNode.findNodeInHierarchy(testNode.getAwardNumber()));
        AwardHierarchy lastChildNode = (AwardHierarchy)rootNode.getChildren().get(rootNode.getChildren().size() - 1);
        AwardHierarchy lastGrandChildNode = (AwardHierarchy)lastChildNode.getChildren().get(lastChildNode.getChildren().size() - 1);
        Assert.assertEquals((Object)testNode, (Object)lastGrandChildNode.findNodeInHierarchy(testNode.getAwardNumber()));
    }

    @Test
    public void testFindingAssociatedAward_ActiveAward() {
        Long awardId = 1001L;
        Assert.assertEquals((Object)awardId, (Object)this.prepareSingleNode(VersionStatus.ACTIVE, awardId).getAward().getAwardId());
    }

    @Test
    public void testFindingAssociatedAward_PendingAward() {
        Long awardId = 1001L;
        Assert.assertEquals((Object)awardId, (Object)this.prepareSingleNode(VersionStatus.PENDING, awardId).getAward().getAwardId());
    }

    @Test
    public void testFindingAssociatedAward_PendingAndActiveAwardsExist() {
        ArrayList<Award> awards = new ArrayList<Award>();
        ArrayList<VersionHistory> versionHistories = new ArrayList<VersionHistory>();
        Long awardId_Active = 1001L;
        Award award = new Award();
        award.setAwardId(awardId_Active);
        award.setAwardNumber(this.generateAwardNumber(100001L, 1));
        awards.add(award);
        VersionHistory versionHistory = new VersionHistory((SequenceOwner)award, VersionStatus.ACTIVE, "quickstart", new Date(System.currentTimeMillis()));
        versionHistories.add(versionHistory);
        Long awardId_Pending = 1002L;
        award = new Award();
        award.setAwardId(awardId_Pending);
        award.setAwardNumber(this.generateAwardNumber(100001L, 2));
        awards.add(award);
        versionHistory = new VersionHistory((SequenceOwner)award, VersionStatus.PENDING, "quickstart", new Date(System.currentTimeMillis()));
        versionHistories.add(versionHistory);
        AwardHierarchy node = new AwardHierarchy(award.getAwardNumber(), "000000-00000", award.getAwardNumber());
        node.setAward(null);
        node.setVersionHistoryService((VersionHistoryService)this.prepareVersionHistoryService(awards, versionHistories));
        Assert.assertEquals((Object)awardId_Active, (Object)node.getAward().getAwardId());
    }

    @Test
    public void testGettingFlattenedListOfNodesInHiearchy() {
        Assert.assertEquals((long)61L, (long)this.createFullHierarchy().getFlattenedListOfNodesInHierarchy().size());
    }

    @Test
    public void testGeneratingNextAwardNumberInSequence() {
        Assert.assertEquals((Object)String.format("100001-%05d", 62), (Object)this.createFullHierarchy().generateNextAwardNumberInSequence());
    }

    private AwardHierarchy createFullHierarchy() {
        int i;
        Award award = this.createRootAward();
        AwardHierarchy rootNodeA = AwardHierarchy.createRootNode((Award)award);
        ArrayList<AwardHierarchy> childNodes = new ArrayList<AwardHierarchy>();
        int sequenceNo = i + 2;
        for (i = 0; i < 10; ++i) {
            AwardHierarchy childBranchNode = new AwardHierarchy(rootNodeA, rootNodeA, this.generateAwardNumber(100001L, sequenceNo++), rootNodeA.getAwardNumber());
            childNodes.add(childBranchNode);
            ArrayList<AwardHierarchy> grandchildNodes = new ArrayList<AwardHierarchy>();
            for (int j = 0; j < 5; ++j) {
                grandchildNodes.add(new AwardHierarchy(rootNodeA, childBranchNode, this.generateAwardNumber(100001L, sequenceNo++), rootNodeA.getAwardNumber()));
            }
            childBranchNode.setChildren(grandchildNodes);
        }
        rootNodeA.setChildren(childNodes);
        return rootNodeA;
    }

    private Award createRootAward() {
        Award award = new Award();
        award.setAwardNumber(this.generateAwardNumber(100001L, 1));
        return award;
    }

    private String generateAwardNumber(long baseAwardNumber, int hierarchySequenceNumber) {
        return String.format(AWARD_NUMBER_PATTERN, baseAwardNumber, hierarchySequenceNumber);
    }

    private AwardHierarchy prepareSingleNode(VersionStatus status, Long awardId) {
        Award award = new Award();
        award.setAwardId(awardId);
        award.setAwardNumber(this.generateAwardNumber(100001L, 1));
        VersionHistory versionHistory = new VersionHistory((SequenceOwner)award, status, "quickstart", new Date(System.currentTimeMillis()));
        AwardHierarchy node = new AwardHierarchy(award.getAwardNumber(), "000000-00000", award.getAwardNumber());
        node.setAward(null);
        node.setVersionHistoryService((VersionHistoryService)this.prepareVersionHistoryService(award, versionHistory));
        return node;
    }

    private VersionHistoryServiceImpl prepareVersionHistoryService(Award award, VersionHistory versionHistory) {
        ArrayList<Award> awards = new ArrayList<Award>();
        awards.add(award);
        ArrayList<VersionHistory> versionHistories = new ArrayList<VersionHistory>();
        versionHistories.add(versionHistory);
        return this.prepareVersionHistoryService(awards, versionHistories);
    }

    private VersionHistoryServiceImpl prepareVersionHistoryService(final Collection<Award> awards, final Collection<VersionHistory> versionHistories) {
        BusinessObjectServiceAdapter bosAdapter = new BusinessObjectServiceAdapter(){

            public Collection findMatching(Class klass, Map fieldValues) {
                if (klass.equals(Award.class)) {
                    return awards;
                }
                if (klass.equals(VersionHistory.class)) {
                    return versionHistories;
                }
                return null;
            }
        };
        VersionHistoryServiceImpl vhs = new VersionHistoryServiceImpl();
        vhs.setBusinessObjectService((BusinessObjectService)bosAdapter);
        return vhs;
    }
}

