/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncAwardHelperTest
extends AwardSyncHelperTestBase {
    private String sponsorCode = "0005000";
    private Integer statusCode = 1;

    public AwardSyncAwardHelperTest() {
        super("Award");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.award.setSponsorCode(this.sponsorCode);
        this.award.setStatusCode(this.statusCode);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.award, "sponsorCode");
        AwardSyncAwardHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncAwardHelperTest.assertFalse((boolean)xmlExport.getValues().isEmpty());
        AwardSyncAwardHelperTest.assertEquals(xmlExport.getValues().get("sponsorCode"), (Object)this.sponsorCode);
        xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.award, "statusCode");
        AwardSyncAwardHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncAwardHelperTest.assertFalse((boolean)xmlExport.getValues().isEmpty());
        AwardSyncAwardHelperTest.assertEquals(xmlExport.getValues().get("statusCode"), (Object)this.statusCode);
    }

    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.award, null, "sponsorCode");
        AwardSyncAwardHelperTest.assertNotNull((Object)change);
        AwardSyncAwardHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.award, "sponsorCode", "sponsorCode");
        this.award.setSponsorCode("0009906");
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncAwardHelperTest.assertEquals((Object)this.award.getSponsorCode(), (Object)this.sponsorCode);
    }
}

