/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperTestBase;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.bo.CommentType;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncCommentsHelperTest
extends AwardSyncHelperTestBase {
    protected AwardComment comment;
    protected final String awardTypeCode1 = "2";
    protected final String awardTestComment1 = "Test Comment";
    protected final String awardTestComment2 = "My new comment";

    public AwardSyncCommentsHelperTest() {
        super("AwardComment");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.comment = new AwardComment();
        this.comment.setCommentType(new CommentType());
        this.comment.getCommentType().setCommentTypeCode("2");
        this.comment.getCommentType().setDescription("Test Comment Type");
        this.comment.setCommentTypeCode("2");
        this.comment.setComments("Test Comment");
        AwardComment blankComment = new AwardComment();
        blankComment.setCommentType(this.comment.getCommentType());
        this.award.add(blankComment);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.comment, null);
        AwardSyncCommentsHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncCommentsHelperTest.assertFalse((boolean)xmlExport.getKeys().isEmpty());
        AwardSyncCommentsHelperTest.assertFalse((boolean)xmlExport.getValues().isEmpty());
        AwardSyncCommentsHelperTest.assertEquals((Object)this.comment.getCommentTypeCode(), xmlExport.getKeys().get("commentTypeCode"));
        AwardSyncCommentsHelperTest.assertEquals((Object)this.comment.getComments(), xmlExport.getValues().get("comments"));
    }

    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.comment, "awardComments", null);
        AwardSyncCommentsHelperTest.assertNotNull((Object)change);
        AwardSyncCommentsHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.comment, "awardComments", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncCommentsHelperTest.assertFalse((boolean)this.award.getAwardComments().isEmpty());
        AwardSyncCommentsHelperTest.assertEquals((Object)this.award.getAwardCommentByType("2", false, false).getComments(), (Object)"Test Comment");
        this.comment.setComments("My new comment");
        change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.comment, "awardComments", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncCommentsHelperTest.assertFalse((boolean)this.award.getAwardComments().isEmpty());
        AwardSyncCommentsHelperTest.assertTrue((boolean)this.award.getAwardCommentByType("2", false, false).getComments().contains("Test Comment"));
        AwardSyncCommentsHelperTest.assertTrue((boolean)this.award.getAwardCommentByType("2", false, false).getComments().contains("My new comment"));
    }
}

