/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperTestBase;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncPersonHelperTest
extends AwardSyncHelperTestBase {
    protected AwardPerson person;
    protected static final String unitNumber = "000001";

    public AwardSyncPersonHelperTest() {
        super("AwardPerson");
    }

    protected AwardSyncPersonHelperTest(String className) {
        super(className);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.person = new AwardPerson();
        this.person.setAcademicYearEffort(new KualiDecimal(100.0));
        this.person.setCalendarYearEffort(new KualiDecimal(100.0));
        this.person.setRoleCode("PI");
        this.person.setFaculty(false);
        this.person.setPersonId("10000000001");
        AwardPersonUnit unit = new AwardPersonUnit();
        unit.setAwardPerson(this.person);
        unit.setLeadUnit(true);
        unit.setUnitNumber(unitNumber);
        this.person.add(unit);
        unit.setAwardPerson(this.person);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.person, null);
        AwardSyncPersonHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncPersonHelperTest.assertFalse((boolean)xmlExport.getKeys().isEmpty());
        AwardSyncPersonHelperTest.assertFalse((boolean)xmlExport.getValues().isEmpty());
        AwardSyncPersonHelperTest.assertEquals((Object)this.person.getFullName(), xmlExport.getValues().get("fullName"));
        AwardSyncPersonHelperTest.assertEquals((Object)this.person.getRoleCode(), xmlExport.getKeys().get("roleCode"));
        AwardSyncPersonHelperTest.assertEquals((Object)this.person.getCalendarYearEffort(), xmlExport.getValues().get("calendarYearEffort"));
    }

    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.person, "projectPersons", null);
        AwardSyncPersonHelperTest.assertNotNull((Object)change);
        AwardSyncPersonHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.person, "projectPersons", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncPersonHelperTest.assertFalse((boolean)this.award.getProjectPersons().isEmpty());
        AwardSyncPersonHelperTest.assertEquals((Object)this.award.getProjectPerson(0).getFullName(), (Object)this.person.getFullName());
        AwardSyncPersonHelperTest.assertFalse((boolean)this.award.getProjectPerson(0).getUnits().isEmpty());
        change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.person, "projectPersons", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncPersonHelperTest.assertTrue((boolean)this.award.getProjectPersons().isEmpty());
    }
}

