/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperTestBase;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.award.home.Distribution;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.bo.Rolodex;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncReportHelperTest
extends AwardSyncHelperTestBase {
    protected AwardReportTerm report;
    protected AwardReportTermRecipient recipient;

    public AwardSyncReportHelperTest() {
        super("AwardReportTerm");
    }

    protected AwardSyncReportHelperTest(String className) {
        super(className);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.report = new AwardReportTerm();
        this.report.setFrequencyCode("1");
        this.report.setFrequency(new Frequency());
        this.report.getFrequency().setDescription("Test Frequency");
        this.report.getFrequency().setFrequencyCode("1");
        this.report.setFrequencyBaseCode("1");
        this.report.setFrequencyBase(new FrequencyBase());
        this.report.getFrequencyBase().setFrequencyBaseCode("1");
        this.report.getFrequencyBase().setDescription("Test Frequency Base");
        this.report.setReportClassCode("1");
        this.report.setReportClass(new ReportClass());
        this.report.getReportClass().setReportClassCode("1");
        this.report.getReportClass().setDescription("Test Report Class");
        this.report.setReportCode("1");
        this.report.setReport(new Report());
        this.report.getReport().setReportCode("1");
        this.report.getReport().setDescription("Test Report");
        this.report.setOspDistributionCode("1");
        this.report.setDistribution(new Distribution());
        this.report.getDistribution().setDescription("Test Distribution");
        this.report.getDistribution().setOspDistributionCode("1");
        this.recipient = new AwardReportTermRecipient();
        this.recipient.setAwardReportTerm(this.report);
        this.recipient.setRolodexId(Integer.valueOf(1));
        this.recipient.setRolodex(new Rolodex());
        this.recipient.getRolodex().setFirstName("Test");
        this.recipient.getRolodex().setLastName("Person");
        this.recipient.setNumberOfCopies(Integer.valueOf(5));
        this.recipient.setContactTypeCode("1");
        this.recipient.setContactType(new ContactType());
        this.recipient.getContactType().setContactTypeCode("1");
        this.recipient.getContactType().setDescription("Test Contact Type");
        this.report.getAwardReportTermRecipients().add(this.recipient);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.report, null);
        AwardSyncReportHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncReportHelperTest.assertFalse((boolean)xmlExport.getKeys().isEmpty());
        AwardSyncReportHelperTest.assertFalse((boolean)xmlExport.getValues().isEmpty());
        AwardSyncReportHelperTest.assertEquals((Object)this.report.getFrequencyCode(), xmlExport.getKeys().get("frequencyCode"));
        AwardSyncReportHelperTest.assertEquals((Object)this.report.getOspDistributionCode(), xmlExport.getValues().get("ospDistributionCode"));
    }

    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.report, "awardReportTermItems", null);
        AwardSyncReportHelperTest.assertNotNull((Object)change);
        AwardSyncReportHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.report, "awardReportTermItems", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncReportHelperTest.assertFalse((boolean)this.award.getAwardReportTermItems().isEmpty());
        AwardSyncReportHelperTest.assertEquals((Object)((AwardReportTerm)this.award.getAwardReportTermItems().get(0)).getFrequencyCode(), (Object)this.report.getFrequencyCode());
        AwardSyncReportHelperTest.assertFalse((boolean)((AwardReportTerm)this.award.getAwardReportTermItems().get(0)).getAwardReportTermRecipients().isEmpty());
        change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.report, "awardReportTermItems", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncReportHelperTest.assertTrue((boolean)this.award.getAwardReportTermItems().isEmpty());
    }
}

