/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import java.io.Serializable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncException;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncReportHelperTest;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardSyncReportRecipientHelperTest
extends AwardSyncReportHelperTest {
    public AwardSyncReportRecipientHelperTest() {
        super("AwardReportTermRecipient");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.recipient, null);
        AwardSyncXmlExport recipientExport = (AwardSyncXmlExport)xmlExport.getValues().get("awardReportTermRecipients");
        AwardSyncReportRecipientHelperTest.assertNotNull((Object)recipientExport);
        AwardSyncReportRecipientHelperTest.assertFalse((boolean)recipientExport.getKeys().isEmpty());
        AwardSyncReportRecipientHelperTest.assertFalse((boolean)recipientExport.getValues().isEmpty());
        AwardSyncReportRecipientHelperTest.assertEquals((Object)this.recipient.getRolodexId(), recipientExport.getKeys().get("rolodexId"));
        AwardSyncReportRecipientHelperTest.assertEquals((Object)this.recipient.getNumberOfCopies(), recipientExport.getValues().get("numberOfCopies"));
    }

    @Override
    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.recipient, "awardReportTermItems", null);
        AwardSyncReportRecipientHelperTest.assertNotNull((Object)change);
        AwardSyncReportRecipientHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Override
    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.recipient, "awardReportTermItems", null);
        AwardReportTerm newReport = (AwardReportTerm)ObjectUtils.deepCopy((Serializable)this.report);
        newReport.getAwardReportTermRecipients().clear();
        this.award.add(newReport);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncReportRecipientHelperTest.assertFalse((boolean)((AwardReportTerm)this.award.getAwardReportTermItems().get(0)).getAwardReportTermRecipients().isEmpty());
        AwardSyncReportRecipientHelperTest.assertEquals((Object)this.recipient.getNumberOfCopies(), (Object)((AwardReportTermRecipient)((AwardReportTerm)this.award.getAwardReportTermItems().get(0)).getAwardReportTermRecipients().get(0)).getNumberOfCopies());
        change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.recipient, "awardReportTermItems", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncReportRecipientHelperTest.assertTrue((boolean)((AwardReportTerm)this.award.getAwardReportTermItems().get(0)).getAwardReportTermRecipients().isEmpty());
    }

    @Test(expected=AwardSyncException.class)
    public void testApplySyncChangeWithException() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.recipient, "awardReportTermItems", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
    }
}

