/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperTestBase;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncSponsorContactHelperTest
extends AwardSyncHelperTestBase {
    protected AwardSponsorContact contact;

    public AwardSyncSponsorContactHelperTest() {
        super("AwardSponsorContact");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.contact = new AwardSponsorContact();
        this.contact.setRolodexId(Integer.valueOf(1));
        this.contact.setRoleCode("1");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.contact, null);
        AwardSyncSponsorContactHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncSponsorContactHelperTest.assertFalse((boolean)xmlExport.getKeys().isEmpty());
        AwardSyncSponsorContactHelperTest.assertFalse((boolean)xmlExport.getValues().isEmpty());
        AwardSyncSponsorContactHelperTest.assertEquals((Object)this.contact.getRolodexId(), xmlExport.getKeys().get("rolodexId"));
        AwardSyncSponsorContactHelperTest.assertEquals((Object)this.contact.getRoleCode(), xmlExport.getKeys().get("roleCode"));
    }

    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.contact, "sponsorContacts", null);
        AwardSyncSponsorContactHelperTest.assertNotNull((Object)change);
        AwardSyncSponsorContactHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.contact, "sponsorContacts", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncSponsorContactHelperTest.assertFalse((boolean)this.award.getSponsorContacts().isEmpty());
        AwardSyncSponsorContactHelperTest.assertEquals((Object)this.contact.getRoleCode(), (Object)((AwardSponsorContact)this.award.getSponsorContacts().get(0)).getRoleCode());
        change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.contact, "sponsorContacts", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncSponsorContactHelperTest.assertTrue((boolean)this.award.getSponsorContacts().isEmpty());
    }
}

