/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperTestBase;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.bo.SponsorTerm;
import org.kuali.kra.bo.SponsorTermType;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncTermHelperTest
extends AwardSyncHelperTestBase {
    protected AwardSponsorTerm term;
    protected SponsorTerm sponsorTerm;
    protected static final Long sponsorTermId = 1L;

    public AwardSyncTermHelperTest() {
        super("AwardSponsorTerm");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sponsorTerm = new SponsorTerm();
        this.sponsorTerm.setSponsorTermId(sponsorTermId);
        this.sponsorTerm.setDescription("Test Sponsor Term");
        SponsorTermType type = new SponsorTermType();
        type.setDescription("Test Sponsor Term Type");
        type.setSponsorTermTypeCode("1");
        this.sponsorTerm.setSponsorTermType(type);
        this.term = new AwardSponsorTerm();
        this.term.setSponsorTerm(this.sponsorTerm);
        this.term.setSponsorTermId(sponsorTermId);
    }

    @Override
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.term, null);
        AwardSyncTermHelperTest.assertNotNull((Object)xmlExport);
        AwardSyncTermHelperTest.assertFalse((boolean)xmlExport.getKeys().isEmpty());
        AwardSyncTermHelperTest.assertEquals((Object)sponsorTermId, xmlExport.getKeys().get("sponsorTermId"));
    }

    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.term, "awardSponsorTerms", null);
        AwardSyncTermHelperTest.assertNotNull((Object)change);
        AwardSyncTermHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.term, "awardSponsorTerms", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncTermHelperTest.assertFalse((boolean)this.award.getAwardSponsorTerms().isEmpty());
        AwardSyncTermHelperTest.assertEquals((Object)sponsorTermId, (Object)((AwardSponsorTerm)this.award.getAwardSponsorTerms().get(0)).getSponsorTermId());
    }
}

