/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import java.io.Serializable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncException;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncPersonHelperTest;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.bo.Unit;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardSyncUnitHelperTest
extends AwardSyncPersonHelperTest {
    protected AwardPersonUnit unit;
    protected Unit leadUnit;

    public AwardSyncUnitHelperTest() {
        super("AwardPersonUnit");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.unit = this.person.getUnit(0);
        this.leadUnit = new Unit();
        this.leadUnit.setUnitNumber("000001");
        this.unit.setUnit(this.leadUnit);
        this.award.setLeadUnit(this.leadUnit);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testBuildXmlExport() throws Exception {
        AwardSyncXmlExport xmlExport = this.awardSyncHelper.buildXmlExport((PersistableBusinessObject)this.unit, null);
        AwardSyncXmlExport unitExport = (AwardSyncXmlExport)xmlExport.getValues().get("units");
        AwardSyncUnitHelperTest.assertNotNull((Object)unitExport);
        AwardSyncUnitHelperTest.assertFalse((boolean)unitExport.getKeys().isEmpty());
        AwardSyncUnitHelperTest.assertFalse((boolean)unitExport.getValues().isEmpty());
        AwardSyncUnitHelperTest.assertEquals((Object)this.unit.getUnitNumber(), unitExport.getKeys().get("unitNumber"));
        AwardSyncUnitHelperTest.assertEquals((Object)this.unit.isLeadUnit(), unitExport.getValues().get("leadUnit"));
    }

    @Override
    @Test
    public void testCreateAwardSyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.unit, "projectPersons", null);
        AwardSyncUnitHelperTest.assertNotNull((Object)change);
        AwardSyncUnitHelperTest.assertNotNull((Object)change.getXmlExport());
    }

    @Override
    @Test
    public void testApplySyncChange() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.unit, "projectPersons", null);
        AwardPerson newPerson = (AwardPerson)ObjectUtils.deepCopy((Serializable)this.person);
        newPerson.getUnits().clear();
        this.award.add(newPerson);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncUnitHelperTest.assertFalse((boolean)this.award.getProjectPerson(0).getUnits().isEmpty());
        AwardSyncUnitHelperTest.assertTrue((boolean)this.award.getProjectPerson(0).getUnit(0).isLeadUnit());
        AwardSyncUnitHelperTest.assertEquals((Object)"000001", (Object)this.award.getProjectPerson(0).getUnit(0).getUnitNumber());
        change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.unit, "projectPersons", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
        AwardSyncUnitHelperTest.assertTrue((boolean)this.award.getProjectPerson(0).getUnits().isEmpty());
    }

    @Test(expected=AwardSyncException.class)
    public void testApplySyncChangeWithException() throws Exception {
        AwardSyncChange change = this.awardSyncHelper.createAwardSyncChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.unit, "projectPersons", null);
        this.awardSyncHelper.applySyncChange(this.award, change);
    }
}

