/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.service;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncCreationService;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncCreationServiceTest
extends KcUnitTestBase {
    private Award award;
    private AwardSyncCreationService awardSyncCreationService;
    private AwardPerson person;
    private AwardPersonUnit personUnit;
    private AwardPersonUnit personUnit2;

    @Override
    @Before
    public void setUp() throws Exception {
        this.awardSyncCreationService = (AwardSyncCreationService)KraServiceLocator.getService(AwardSyncCreationService.class);
        this.award = new Award();
        this.person = new AwardPerson();
        this.person.setPersonId("10000000001");
        this.person.setFullName("quickstart");
        this.person.setRoleCode("PI");
        Unit unit = new Unit();
        unit.setUnitName("TestUnit");
        unit.setUnitNumber("000001");
        this.personUnit = new AwardPersonUnit();
        this.personUnit.setAwardPerson(this.person);
        this.personUnit.setLeadUnit(true);
        this.personUnit.setUnit(unit);
        unit = new Unit();
        unit.setUnitName("TestUnit2");
        unit.setUnitNumber("BL-BL");
        this.personUnit2 = new AwardPersonUnit();
        this.personUnit2.setAwardPerson(this.person);
        this.personUnit2.setLeadUnit(false);
        this.personUnit2.setUnit(unit);
        this.person.add(this.personUnit);
        this.person.add(this.personUnit2);
        this.award.add(this.person);
    }

    @Override
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCreateSyncChange() throws Exception {
        AwardSyncPendingChangeBean pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.personUnit, "projectPersons", null);
        AwardSyncChange change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        AwardSyncCreationServiceTest.assertNotNull((Object)change);
        AwardSyncCreationServiceTest.assertTrue((change.getXml().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAddAwardSyncPendingChange() throws Exception {
        AwardSyncPendingChangeBean pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)this.personUnit, "projectPersons", null);
        this.awardSyncCreationService.addAwardSyncChange(this.award, pendingChange);
        AwardSyncCreationServiceTest.assertTrue((!this.award.getSyncChanges().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testAddAwardSyncChange() throws Exception {
        AwardSyncPendingChangeBean pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.personUnit, "projectPersons", null);
        AwardSyncChange change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        this.awardSyncCreationService.addAwardSyncChange(this.award, change);
        AwardSyncCreationServiceTest.assertTrue((!this.award.getSyncChanges().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetXmlExport() throws Exception {
        AwardSyncPendingChangeBean pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.personUnit, "projectPersons", null);
        AwardSyncChange change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        change.setXmlExport(null);
        AwardSyncXmlExport xmlExport = this.awardSyncCreationService.getXmlExport(change);
        AwardSyncCreationServiceTest.assertNotNull((Object)xmlExport);
    }

    @Test
    public void testAddUniqueUnits() throws Exception {
        AwardSyncPendingChangeBean pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.personUnit, "projectPersons", null);
        AwardSyncChange change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        this.awardSyncCreationService.addAwardSyncChange(this.award, change);
        AwardSyncCreationServiceTest.assertTrue((!this.award.getSyncChanges().isEmpty() ? 1 : 0) != 0);
        pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.personUnit2, "projectPersons", null);
        change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        this.awardSyncCreationService.addAwardSyncChange(this.award, change);
        AwardSyncCreationServiceTest.assertEquals((long)2L, (long)this.award.getSyncChanges().size());
    }

    @Test
    public void testAddDuplicateUnits() throws Exception {
        AwardSyncPendingChangeBean pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.personUnit, "projectPersons", null);
        AwardSyncChange change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        this.awardSyncCreationService.addAwardSyncChange(this.award, change);
        AwardSyncCreationServiceTest.assertTrue((!this.award.getSyncChanges().isEmpty() ? 1 : 0) != 0);
        this.personUnit2.setUnit(this.personUnit.getUnit());
        pendingChange = new AwardSyncPendingChangeBean(AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)this.personUnit2, "projectPersons", null);
        change = this.awardSyncCreationService.createAwardSyncChange(pendingChange);
        this.awardSyncCreationService.addAwardSyncChange(this.award, change);
        AwardSyncCreationServiceTest.assertEquals((long)1L, (long)this.award.getSyncChanges().size());
    }
}

