/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.service;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncDescendantValues;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncSelectorService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardStatus;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class AwardSyncSelectorServiceTest
extends KcUnitTestBase {
    protected static final String otherSponsorCode = "000500";
    protected static final String costShareSponsorCode = "009906";
    private AwardSyncSelectorService awardSyncSelectorService;
    private Award award;
    private AwardStatus activeStatus;
    private AwardStatus inactiveStatus;

    @Override
    @Before
    public void setUp() throws Exception {
        this.awardSyncSelectorService = (AwardSyncSelectorService)KraServiceLocator.getService(AwardSyncSelectorService.class);
        this.award = new Award();
        this.activeStatus = new AwardStatus();
        this.activeStatus.setStatusCode("1");
        this.inactiveStatus = new AwardStatus();
        this.inactiveStatus.setStatusCode("2");
    }

    @Override
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIsAwardActive() throws Exception {
        this.award.setAwardStatus(this.inactiveStatus);
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isAwardActive(this.award));
        this.award.setAwardStatus(this.activeStatus);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isAwardActive(this.award));
    }

    @Test
    public void testIsFabricatedAccount() throws Exception {
        this.award.setAccountTypeCode(Integer.valueOf(1));
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isFabricatedAccount(this.award));
        this.award.setAccountTypeCode(Integer.valueOf(2));
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isFabricatedAccount(this.award));
    }

    @Test
    public void testIsCostShareAccount() throws Exception {
        this.award.setSponsorCode(otherSponsorCode);
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isCostShareAccount(this.award));
        this.award.setSponsorCode(costShareSponsorCode);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isCostShareAccount(this.award));
    }

    @Test
    public void testIsAwardInvolvedInSync() throws Exception {
        ArrayList<AwardSyncChange> changes = new ArrayList<AwardSyncChange>();
        AwardSyncChange change1 = new AwardSyncChange();
        change1.setSyncDescendantsType(AwardSyncDescendantValues.SYNC_ACTIVE);
        change1.setSyncFabricated(false);
        change1.setSyncCostSharing(false);
        changes.add(change1);
        AwardSyncChange change2 = new AwardSyncChange();
        change2.setSyncDescendantsType(AwardSyncDescendantValues.SYNC_ACTIVE);
        change2.setSyncFabricated(true);
        change2.setSyncCostSharing(false);
        changes.add(change2);
        this.award.setAwardStatus(this.activeStatus);
        this.award.setAccountTypeCode(Integer.valueOf(1));
        this.award.setSponsorCode(costShareSponsorCode);
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isAwardInvolvedInSync(this.award, changes));
        this.award.setAccountTypeCode(Integer.valueOf(2));
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isAwardInvolvedInSync(this.award, changes));
        this.award.setAwardStatus(this.inactiveStatus);
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isAwardInvolvedInSync(this.award, changes));
        change2.setSyncDescendantsType(AwardSyncDescendantValues.SYNC_ALL);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isAwardInvolvedInSync(this.award, changes));
        this.award.setAccountTypeCode(Integer.valueOf(1));
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isAwardInvolvedInSync(this.award, changes));
    }

    @Test
    public void testIsChangeApplicableToAward() throws Exception {
        AwardSyncChange change = new AwardSyncChange();
        change.setSyncDescendantsType(AwardSyncDescendantValues.SYNC_ALL);
        change.setSyncFabricated(false);
        change.setSyncCostSharing(false);
        this.award.setAwardStatus(this.inactiveStatus);
        this.award.setAccountTypeCode(Integer.valueOf(1));
        this.award.setSponsorCode(otherSponsorCode);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
        change.setSyncDescendantsType(AwardSyncDescendantValues.SYNC_ACTIVE);
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
        this.award.setAwardStatus(this.activeStatus);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
        this.award.setAccountTypeCode(Integer.valueOf(2));
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
        change.setSyncFabricated(true);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
        change.setSyncFabricated(false);
        this.award.setSponsorCode(costShareSponsorCode);
        AwardSyncSelectorServiceTest.assertFalse((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
        change.setSyncCostSharing(true);
        AwardSyncSelectorServiceTest.assertTrue((boolean)this.awardSyncSelectorService.isChangeApplicableToAward(this.award, change));
    }
}

