/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.AwardBudgetServiceImpl;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalBoLite;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.impl.BusinessObjectServiceImpl;

public class AwardBudgetServiceImplTest
extends KcUnitTestBase {
    protected AwardBudgetService awardBudgetService;
    protected String testAwardNumber = "000000-00000";
    protected Long awardId = 1L;
    protected String proposalNumber = "111";
    protected Long proposalId = 2L;
    protected String devProposalNumber = "59";
    protected String devPropDocNumber = "55555";
    protected Long budgetId = 3L;

    @Override
    @Before
    public void setUp() {
    }

    @Test
    public void testFindBudgetPeriodsFromLinkedProposal() {
        this.awardBudgetService = new AwardBudgetServiceImpl(){

            protected List findObjectsWithSingleKey(Class clazz, String key, Object value) {
                return AwardBudgetServiceImplTest.this.mockedFindObjectsWithSingleKey(clazz, key, value);
            }
        };
        ((AwardBudgetServiceImpl)this.awardBudgetService).setBusinessObjectService((BusinessObjectService)new MyBOService());
        List periods = this.awardBudgetService.findBudgetPeriodsFromLinkedProposal(this.testAwardNumber);
        AwardBudgetServiceImplTest.assertTrue((periods.size() == 2 ? 1 : 0) != 0);
        AwardBudgetServiceImplTest.assertEquals((Object)this.proposalNumber, (Object)((BudgetPeriod)periods.get(0)).getInstitutionalProposalNumber());
    }

    protected List mockedFindObjectsWithSingleKey(Class clazz, String key, Object value) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (clazz == Award.class) {
            AwardBudgetServiceImplTest.assertEquals((Object)this.testAwardNumber, (Object)value);
            Award temp = new Award();
            temp.setAwardId(this.awardId);
            result.add(temp);
        } else if (clazz == AwardFundingProposal.class) {
            AwardBudgetServiceImplTest.assertEquals((Object)this.awardId, (Object)value);
            AwardFundingProposal temp = new AwardFundingProposal();
            temp.setActive(true);
            InstitutionalProposalBoLite proposal = new InstitutionalProposalBoLite();
            proposal.setProposalNumber(this.proposalNumber);
            temp.setProposal(proposal);
            result.add(temp);
            temp = new AwardFundingProposal();
            temp.setActive(false);
            result.add(temp);
        } else if (clazz == InstitutionalProposal.class) {
            AwardBudgetServiceImplTest.assertEquals((Object)this.proposalNumber, (Object)value);
            InstitutionalProposal temp = new InstitutionalProposal();
            temp.setProposalId(this.proposalId);
            temp.setProposalNumber(this.proposalNumber);
            temp.setSequenceNumber(Integer.valueOf(1));
            result.add(temp);
        } else if (clazz == ProposalAdminDetails.class) {
            AwardBudgetServiceImplTest.assertEquals((Object)this.proposalId, (Object)value);
            ProposalAdminDetails temp = new ProposalAdminDetails();
            temp.setDevProposalNumber(this.devProposalNumber);
            result.add(temp);
        } else if (clazz == BudgetDocumentVersion.class) {
            AwardBudgetServiceImplTest.assertEquals((Object)this.devPropDocNumber, (Object)value);
            BudgetDocumentVersion temp = new BudgetDocumentVersion();
            BudgetVersionOverview overview = new BudgetVersionOverview();
            overview.setBudgetId(this.budgetId);
            temp.getBudgetVersionOverviews().add(overview);
            result.add(temp);
        }
        return result;
    }

    class MyBOService
    extends BusinessObjectServiceImpl {
        public <T extends BusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object value) {
            if (clazz == DevelopmentProposal.class) {
                Assert.assertEquals((Object)AwardBudgetServiceImplTest.this.devProposalNumber, (Object)value);
                DevelopmentProposal temp = new DevelopmentProposal();
                ProposalDevelopmentDocument doc = new ProposalDevelopmentDocument();
                doc.setDocumentNumber(AwardBudgetServiceImplTest.this.devPropDocNumber);
                temp.setProposalDocument(doc);
                return (T)temp;
            }
            if (clazz == ProposalDevelopmentBudgetExt.class) {
                Assert.assertEquals((Object)AwardBudgetServiceImplTest.this.budgetId, (Object)value);
                ProposalDevelopmentBudgetExt temp = new ProposalDevelopmentBudgetExt();
                temp.add(new BudgetPeriod());
                temp.add(new BudgetPeriod());
                temp.setFinalVersionFlag(true);
                return (T)temp;
            }
            return null;
        }
    }
}

