/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardCostShareAuditRule;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardCostShareAuditRuleTest {
    private static final String TEST_SOURCE = "54321";
    private static final String TEST_DESTINATION = "12345";
    private static final String TEST_FISCAL_YEAR = "2008";
    private static final String TEST_FISCAL_YEAR_2 = "2009";
    private static final String TEST_INVALID_FISCAL_YEAR = "1000";
    private static final Integer TEST_COST_SHARE_TYPE = 1;
    private static final Integer PERCENTAGE = 50;
    private static final Integer COMMITMENT_AMOUNT = 10000;
    AwardCostShareAuditRule awardCostShareAuditRule;
    List<AwardCostShare> awardCostShares = new ArrayList<AwardCostShare>();

    @Before
    public void setUp() throws Exception {
        this.awardCostShareAuditRule = new AwardCostShareAuditRule();
        AwardCostShare awardCostShare = new AwardCostShare();
        awardCostShare.setCostSharePercentage(new KualiDecimal(PERCENTAGE.intValue()));
        awardCostShare.setCostShareTypeCode(TEST_COST_SHARE_TYPE);
        awardCostShare.setProjectPeriod(TEST_FISCAL_YEAR);
        awardCostShare.setDestination(TEST_DESTINATION);
        awardCostShare.setSource(TEST_SOURCE);
        awardCostShare.setCommitmentAmount(new KualiDecimal(COMMITMENT_AMOUNT.intValue()));
        this.awardCostShares.add(awardCostShare);
        awardCostShare = new AwardCostShare();
        awardCostShare.setCostSharePercentage(new KualiDecimal(PERCENTAGE.intValue()));
        awardCostShare.setCostShareTypeCode(TEST_COST_SHARE_TYPE);
        awardCostShare.setProjectPeriod(TEST_FISCAL_YEAR_2);
        awardCostShare.setDestination(TEST_DESTINATION);
        awardCostShare.setSource(TEST_SOURCE);
        awardCostShare.setCommitmentAmount(new KualiDecimal(COMMITMENT_AMOUNT.intValue()));
        this.awardCostShares.add(awardCostShare);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.awardCostShareAuditRule = null;
        this.awardCostShares = null;
    }

    @Test
    public void testCostShareUniqueCheck() throws Exception {
        Assert.assertTrue((boolean)this.awardCostShareAuditRule.validateCostShareDoesNotViolateUniqueConstraint(this.awardCostShares));
        this.awardCostShares.get(1).setProjectPeriod(TEST_FISCAL_YEAR);
        Assert.assertFalse((boolean)this.awardCostShareAuditRule.validateCostShareDoesNotViolateUniqueConstraint(this.awardCostShares));
    }
}

